/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;


import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 *
 * @author virieux
 */
public class SimuBridgeForCPPMTestBench extends BridgeToCanOpenHardware {
    
    protected SimuCanOpenProxy simuTcpProxy;
    public SimuPlutoGateway plutoGateway;
    public SimuEPOSControllerModule latchController;    
    public SimuEPOSControllerModule linearRailMasterController;
    public SimuEPOSControllerModule linearRailSlaveController;   
    public SimuEPOSControllerModule onlineClampController;

    
   
    
    public SimuBridgeForCPPMTestBench(String aName, 
            int aTickMillis, 
            SimuCanOpenProxy tcpProxy,
            SimuPlutoGateway plutoGateway,
            SimuEPOSControllerModule latchController,            
            SimuEPOSControllerModule linearRailMasterController,
            SimuEPOSControllerModule linearRailSlaveController,
            SimuEPOSControllerModule onlineClampController){
        super(aName, aTickMillis, tcpProxy);
        this.simuTcpProxy = tcpProxy;
        this.plutoGateway = plutoGateway;
        this.latchController = latchController;        
        this.linearRailMasterController = linearRailMasterController;
        this.linearRailSlaveController = linearRailSlaveController;
        this.onlineClampController = onlineClampController;
    }
    
    @Override
    public boolean isRealHardware() {
        return false;
    }
    
    @Override
    public boolean isCWrapperConnected() {
        return true;
    }

    @Override
    public boolean isHardwareReady() {
        return true;
    }
    
    @Override
    public CanOpenProxy getTcpProxy() {
        return this.simuTcpProxy;
    }
    
    @Override
    public CanOpenProxy.PDOStorage readPDOs() throws FcsHardwareException, BadCommandException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    
    @Override
    public void startServer() {
        tcpProxy.startServer();
    }
    
    @Override
    public void startThreadReader() {
        tcpProxy.startThreadReader();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);        
        sb.append("/plutoGateway=");sb.append(String.valueOf(this.plutoGateway));        
        sb.append("/latchController=");sb.append(String.valueOf(this.latchController));
        sb.append("/linearRailMasterController=");sb.append(String.valueOf(this.linearRailMasterController));
        sb.append("/linearRailSlaveController=");sb.append(String.valueOf(this.linearRailSlaveController));
        sb.append("/onlineClampController=");sb.append(String.valueOf(this.onlineClampController));
        return sb.toString();
    }
    
}
