/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;

/**
 *
 * @author virieux
 */
public class SimuAutochangerPlutoGateway extends SimuPlutoGateway {
    
    //private AutoChangerModule autochanger;
    //trucks controllers
    private AutoChangerTrucksModule trucks;
    //private String trucksName;
    SimuAutochangerLinearRailController trucksController;
    
    
    //latches controllers
    SimuAutochangerLatchController latchXminusController;
    SimuAutochangerLatchController latchXplusController;
    
    //clamps controllers
    SimuAutochangerOnlineClampController onlineClampXminusController;
    SimuAutochangerOnlineClampController onlineClampXplusController;
    SimuAutochangerOnlineClampController onlineClampZController; 
    
    //trucks sensors
    SimuPlutoGWSensor handoffPositionSensor0;    
    SimuPlutoGWSensor handoffPositionSensor1;
    SimuPlutoGWSensor onlinePositionSensor0;    
    SimuPlutoGWSensor onlinePositionSensor1;
    SimuPlutoGWSensor standbyPositionSensor0;
    SimuPlutoGWSensor standbyPositionSensor1;
    SimuPlutoGWSensor loaderConnectedSensor0;
    SimuPlutoGWSensor loaderConnectedSensor1;
    
    //latches sensors
    SimuPlutoGWSensor lockSensorLatchXminus;
    SimuPlutoGWSensor unlockSensorLatchXminus;
    SimuPlutoGWSensor filterPresenceSensorLatchXminus;
    SimuPlutoGWSensor lockSensorLatchXplus;
    SimuPlutoGWSensor unlockSensorLatchXplus;
    SimuPlutoGWSensor filterPresenceSensorLatchXplus;
    
    //clamps sensors
    SimuPlutoGWSensor lockSensorClampXminus;
    SimuPlutoGWSensor lockSensorCClampXminus;
    SimuPlutoGWSensor unlockSensorClampXminus;
    SimuPlutoGWSensor unlockSensorCClampXminus;    
    SimuPlutoGWSensor lockSensorClampXplus;
    SimuPlutoGWSensor lockSensorCClampXplus;
    SimuPlutoGWSensor unlockSensorClampXplus;
    SimuPlutoGWSensor unlockSensorCClampXplus;
    SimuPlutoGWSensor lockSensorClampZ;
    SimuPlutoGWSensor lockSensorCClampZ;
    SimuPlutoGWSensor unlockSensorClampZ;
    SimuPlutoGWSensor unlockSensorCClampZ;    
    
    public SimuAutochangerPlutoGateway(String name, int tickMillis, 
            String nodeID, String serialNB) {
        super(name, tickMillis, nodeID, serialNB);
    }

//    public SimuAutochangerPlutoGateway(String name, int tickMillis, 
//            String nodeID, String serialNB,
//            String trucksName) {
//        super(name, tickMillis, nodeID, serialNB);
//        this.trucksName = trucksName;
//    }
    
    

    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.hexaValues[2] = "00";
        this.hexaValues[3] = "00";
        this.hexaValues[4] = "00";
        this.hexaValues[5] = "00";
        //trucks
        this.handoffPositionSensor0 = (SimuPlutoGWSensor) getModule("handoffPositionSensor0");
        this.handoffPositionSensor1 = (SimuPlutoGWSensor) getModule("handoffPositionSensor1");  
        this.onlinePositionSensor0 = (SimuPlutoGWSensor) getModule("onlinePositionSensor0");
        this.onlinePositionSensor1 = (SimuPlutoGWSensor) getModule("onlinePositionSensor1"); 
        this.standbyPositionSensor0 = (SimuPlutoGWSensor) getModule("standbyPositionSensor0");
        this.standbyPositionSensor1 = (SimuPlutoGWSensor) getModule("standbyPositionSensor1");
        this.loaderConnectedSensor0 = (SimuPlutoGWSensor) getModule("loaderConnectedSensor0");
        this.loaderConnectedSensor1 = (SimuPlutoGWSensor) getModule("loaderConnectedSensor1");
        this.trucksController = (SimuAutochangerLinearRailController) this.getModule("linearRailMasterController");
        this.trucks = (AutoChangerTrucksModule) this.getModule("trucks");   
        simulateAutochangerTrucksIsAtStandby();
        
        //latches
        this.lockSensorLatchXminus = (SimuPlutoGWSensor) getModule("lockSensorLatchXminus");
        this.unlockSensorLatchXminus = (SimuPlutoGWSensor) getModule("unlockSensorLatchXminus");
        this.filterPresenceSensorLatchXminus = (SimuPlutoGWSensor) getModule("filterPresenceSensorLatchXminus");
        this.lockSensorLatchXplus = (SimuPlutoGWSensor) getModule("lockSensorLatchXplus");
        this.unlockSensorLatchXplus = (SimuPlutoGWSensor) getModule("unlockSensorLatchXplus");
        this.filterPresenceSensorLatchXplus = (SimuPlutoGWSensor) getModule("filterPresenceSensorLatchXplus");
        this.latchXminusController = (SimuAutochangerLatchController) this.getModule("latchXminusController");
        this.latchXplusController = (SimuAutochangerLatchController) this.getModule("latchXplusController");
        
        //clamps
        this.lockSensorClampXminus = (SimuPlutoGWSensor) getModule("lockSensorClampXminus");
        this.lockSensorCClampXminus = (SimuPlutoGWSensor) getModule("lockSensorCClampXminus");
        this.unlockSensorClampXminus = (SimuPlutoGWSensor) getModule("unlockSensorClampXminus");
        this.unlockSensorCClampXminus = (SimuPlutoGWSensor) getModule("unlockSensorCClampXminus"); 
        this.lockSensorClampXplus = (SimuPlutoGWSensor) getModule("lockSensorClampXplus");
        this.lockSensorCClampXplus = (SimuPlutoGWSensor) getModule("lockSensorCClampXplus");
        this.unlockSensorClampXplus = (SimuPlutoGWSensor) getModule("unlockSensorClampXplus");
        this.unlockSensorCClampXplus = (SimuPlutoGWSensor) getModule("unlockSensorCClampXplus");
        this.lockSensorClampZ = (SimuPlutoGWSensor) getModule("lockSensorClampZ");
        this.lockSensorCClampZ = (SimuPlutoGWSensor) getModule("lockSensorCClampZ");
        this.unlockSensorClampZ = (SimuPlutoGWSensor) getModule("unlockSensorClampZ");
        this.unlockSensorCClampZ = (SimuPlutoGWSensor) getModule("unlockSensorCClampZ");        
        
        
        
        simulateFilterIsOnAutochanger();
        simulateAutochangerLatchesAreLocked();
        simulateAutochangerOnlineClampsAreUnlocked();
    }   

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsAtHandoff() {
        replaceDigitalValues(standbyPositionSensor0, "0");
        replaceDigitalValues(standbyPositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "1");
        replaceDigitalValues(handoffPositionSensor1, "1");
        replaceDigitalValues(onlinePositionSensor0, "0");
        replaceDigitalValues(onlinePositionSensor1, "0");
        trucksController.setPosition(trucks.getHandoffPosition());
    } 
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsOnline() {
        replaceDigitalValues(standbyPositionSensor0, "0");
        replaceDigitalValues(standbyPositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        replaceDigitalValues(onlinePositionSensor0, "1");
        replaceDigitalValues(onlinePositionSensor1, "1");
        trucksController.setPosition(trucks.getOnlinePosition());
        trucksController.setSsiPosition(trucks.getEncoderRibbonMinValue() +
                trucks.getOnlinePosition());
    }  
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsAtStandby() {
        replaceDigitalValues(standbyPositionSensor0, "1");
        replaceDigitalValues(standbyPositionSensor1, "1");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        replaceDigitalValues(onlinePositionSensor0, "0");
        replaceDigitalValues(onlinePositionSensor1, "0");
        trucksController.setPosition(trucks.getStandbyPosition());
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsInTravel() {
        replaceDigitalValues(standbyPositionSensor0, "0");
        replaceDigitalValues(standbyPositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        replaceDigitalValues(onlinePositionSensor0, "0");
        replaceDigitalValues(onlinePositionSensor1, "0");
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsConnected() {
        replaceDigitalValues(loaderConnectedSensor0, "1");
        replaceDigitalValues(loaderConnectedSensor1, "1");
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsDisconnected() {
        replaceDigitalValues(loaderConnectedSensor0, "0");
        replaceDigitalValues(loaderConnectedSensor1, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateFilterIsOnAutochanger() {
       replaceDigitalValues(filterPresenceSensorLatchXminus, "1"); 
       replaceDigitalValues(filterPresenceSensorLatchXplus, "1");
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsEmpty() {
       replaceDigitalValues(filterPresenceSensorLatchXminus, "0"); 
       replaceDigitalValues(filterPresenceSensorLatchXplus, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerLatchesAreLocked() {
       replaceDigitalValues(lockSensorLatchXminus, "1");
       replaceDigitalValues(unlockSensorLatchXminus, "0");
       replaceDigitalValues(lockSensorLatchXplus, "1");
       replaceDigitalValues(unlockSensorLatchXplus, "0");
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerLatchIsLocked(String latchName) {
        if (latchName.contains("Xminus")) {
           replaceDigitalValues(lockSensorLatchXminus, "1");
           replaceDigitalValues(unlockSensorLatchXminus, "0");
        } else if (latchName.contains("Xplus")) {
           replaceDigitalValues(lockSensorLatchXplus, "1");
           replaceDigitalValues(unlockSensorLatchXplus, "0");
        }
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerLatchIsUnlocked(String latchName) {
        if (latchName.contains("Xminus")) {
           replaceDigitalValues(lockSensorLatchXminus, "0");
           replaceDigitalValues(unlockSensorLatchXminus, "1");
        } else if (latchName.contains("Xplus")) {
           replaceDigitalValues(lockSensorLatchXplus, "0");
           replaceDigitalValues(unlockSensorLatchXplus, "1");
        }
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampsAreLocked() {
        simulateAutochangerOnlineClampXminusIsLocked(); 
        simulateAutochangerOnlineClampXplusIsLocked(); 
        simulateAutochangerOnlineClampZIsLocked(); 
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampsAreUnlocked() {
        simulateAutochangerOnlineClampXminusIsUnlocked(); 
        simulateAutochangerOnlineClampXplusIsUnlocked(); 
        simulateAutochangerOnlineClampZIsUnlocked(); 
    }    


    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampIsLocked(SimuPlutoGWSensor lockSensor,
            SimuPlutoGWSensor lockSensorC,
            SimuPlutoGWSensor unlockSensor,
            SimuPlutoGWSensor unlockSensorC) {
        replaceDigitalValues(lockSensor, "1");
        replaceDigitalValues(lockSensorC, "0");
        replaceDigitalValues(unlockSensor, "0");
        replaceDigitalValues(unlockSensorC, "1");
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampIsUnlocked(SimuPlutoGWSensor lockSensor,
            SimuPlutoGWSensor lockSensorC,
            SimuPlutoGWSensor unlockSensor,
            SimuPlutoGWSensor unlockSensorC) {
        replaceDigitalValues(lockSensor, "0");
        replaceDigitalValues(lockSensorC, "1");
        replaceDigitalValues(unlockSensor, "1");
        replaceDigitalValues(unlockSensorC, "0");
    }    
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampXminusIsLocked() {
        simulateAutochangerOnlineClampIsLocked(lockSensorClampXminus,
                lockSensorCClampXminus,
                unlockSensorClampXminus,
                unlockSensorCClampXminus);    
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampXminusIsUnlocked() {
        simulateAutochangerOnlineClampIsUnlocked(lockSensorClampXminus,
                lockSensorCClampXminus,
                unlockSensorClampXminus,
                unlockSensorCClampXminus);    
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampXplusIsLocked() {
        simulateAutochangerOnlineClampIsLocked(lockSensorClampXplus,
                lockSensorCClampXplus,
                unlockSensorClampXplus,
                unlockSensorCClampXplus);    
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampXplusIsUnlocked() {
        simulateAutochangerOnlineClampIsUnlocked(lockSensorClampXplus,
                lockSensorCClampXplus,
                unlockSensorClampXplus,
                unlockSensorCClampXplus);    
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampZIsLocked() {
        simulateAutochangerOnlineClampIsLocked(lockSensorClampZ,
                lockSensorCClampZ,
                unlockSensorClampZ,
                unlockSensorCClampZ);    
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampZIsUnlocked() {
        simulateAutochangerOnlineClampIsUnlocked(lockSensorClampZ,
                lockSensorCClampZ,
                unlockSensorClampZ,
                unlockSensorCClampZ);    
    }    
}
