package org.lsst.ccs.subsystems.fcs.simulation;


import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;


/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author virieux
 */
public class SimuAutochangerLatchController extends SimuEPOSControllerModule {
    
    String latchName;
    AutochangerLatchModule latch;
    SimuAutochangerPlutoGateway plutoGateway;
    
    public SimuAutochangerLatchController(String aName, int aTickMillis, 
            String nodeID, String serialNB, 
            String latchName,
            Map<String, Integer> paramsForCurrent, 
            Map<String, Integer> paramsForProfilePosition, 
            Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB, 
                paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.mode = EPOSEnumerations.EposMode.CURRENT;
        this.latchName = latchName;
    }
    
    @Override
    public void initModule() {
        //Doesn't work with testbenchCPPM__hardware.groovy
//        super.initModule();
        log.debug(name + ":latchName=" + latchName);
        latch = (AutochangerLatchModule)this.getModule(latchName);
        plutoGateway = (SimuAutochangerPlutoGateway)this.getModule("plutoGateway");
    }
    
    @Override
    public void writeCurrent(int aValue) throws BadCommandException, 
            SDORequestException {
        this.targetCurrent = aValue;
        int currentInitial = this.actualCurrent;
        fcslog.debug("=>initial current="+actualCurrent);
        int stepsNB = 10;
        int step = (targetCurrent - this.actualCurrent)/stepsNB;
        
        for (int i=1; i<=stepsNB; i++) {           
            if (i<stepsNB) this.actualCurrent = currentInitial + (i*step);
            //because in the last iteration the actual current could be 
            //different from the target value.
            else this.actualCurrent = aValue;
            latch.updateCurrent();
            if (actualCurrent == latch.getCurrentToOpen()) {
                log.debug("plutoGateway="+ plutoGateway.toString());
                this.plutoGateway.simulateAutochangerLatchIsUnlocked(latchName);

            } else if (actualCurrent == -latch.getCurrentToOpen() ) {
                this.plutoGateway.simulateAutochangerLatchIsLocked(latchName);
            }
            latch.publishData();
            fcslog.debug("i="+i+",actualCurrent="+actualCurrent);
            try {
                Thread.sleep(200);
                if (latch.getHaltRequired().get()) {
                    log.debug(name + " STOP simulated latch motion.");
                    return;
                }
            } catch (InterruptedException ex) {
                throw new BadCommandException(name+" sleep was interrupted.");
            }

        } 
    }
    
    @Override
    public String off() throws SDORequestException, BadCommandException, 
            ErrorInCommandExecutionException {
        writeCurrent(0);
        return name + " is OFF";
    }

    @Override
    public void disable() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    
}
