/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy.PDOStorage;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

/**
 * This is a driver for a thermometer we have in the APC test bench.
 * @author virieux
 */
public class CanOpenThermometer extends CanOpenSensor14bits implements Thermometer {
    
    double temperature;

    public CanOpenThermometer(String moduleName, int aTickMillis, String adcName, int numOfAnalogInput) {
        super(moduleName, aTickMillis, adcName, numOfAnalogInput);
    }

    
    
    

    /**
     * This methods translate the hexa value return by a sensor to the double value.
     * @param valueInHexa
     * @return the corresponding double value
     */
    public static double getDoubleValue(String valueInHexa) {
        double temp = 0;
        fcslog.debug("Value in HEXA=" + valueInHexa);
            
            int valueInt = Integer.parseInt(valueInHexa, 16); //voltage in V
            double voltage = valueInt * CanOpenADC.adcVoltsPerBit;
            fcslog.debug("Input Value read on the ADC:" + valueInt);
            fcslog.debug("Voltage = " + voltage + " volts");
            temp = (voltage / 10) - CanOpenADC.waterFreezeTemp;
            return temp;
    }
    
    @Override
    public double readTemperature() throws HardwareNotDetectedException, SDORequestException  {
        double voltage;
        try {
            voltage = adc.readVoltage(numOfAnalogInput);
            temperature = (voltage / 10) - CanOpenADC.waterFreezeTemp;
        } catch (ShortResponseToSDORequestException ex) {
            fcslog.warning(name + ": could'nt read temperature:" + ex.getMessage());
        }
        return temperature;
            
    }

    @Override
    public double readTemperatureWithPDO(PDOStorage pdo) throws BadCommandException {
        
        if (!this.adc.isInitialized()) throw new BadCommandException("Can't read temperature from PDO if Can Open device is not initialized.");
        
        if (!this.adc.transmissionType.equals("1")) throw new BadCommandException("Transmission type for Can Open device must be 1");
        
        String hexa = pdo.getVarValue(this.adc.nodeID, Integer.toString(this.numOfAnalogInput));
        return getDoubleValue(hexa);
    }
    

    
}
