/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * A model for a Can Open Node : a device on the Can Open Bus.
 * @author virieux
 */
public class CanOpenNode  {
    
    protected static final Logger fcslog = FcsUtils.log;

    private final String nodeID;
    private String type;
    private String vendorID;
    private String productCode;
    private String revisionNB;
    private String serialNB;
    private boolean identified;
    
    public CanOpenNode(String id) {
        //TODO
        //id can't be > 127
        nodeID = id;
        type = "0";
        vendorID = "0";
        productCode = "0";
        revisionNB = "0";
        serialNB = "0";
        identified = false;
    }
    
        
    /**************************************************************************************************/
    /********************** SETTERS AND GETTERS  ******************************************************/
    /**************************************************************************************************/
    
    

    /**
     * @return the nodeID
     */
    public String getNodeID() {
        return nodeID;
    }

    /**
     * @return the type
     */
    public String getType() {
        return type;
    }

    /**
     * @return the vendorID
     */
    public String getVendorID() {
        return vendorID;
    }

    /**
     * @return the productCode
     */
    public String getProductCode() {
        return productCode;
    }

    /**
     * @return the revisionNB
     */
    public String getRevisionNB() {
        return revisionNB;
    }

    /**
     * @return the serialNB
     */
    public String getSerialNB() {
        return serialNB;
    }

    /**
     * @param serialNB the serialNB to set
     */
    public void setSerialNB(String serialNB) {
        this.serialNB = serialNB;
    }

    public boolean isIdentified() {
        return identified;
    }
    
    /**************************************************************************************************/
    /********************** END OF SETTERS AND GETTERS  ***********************************************/
    /**************************************************************************************************/

    
    public synchronized void setNodeInfo(String type, String vendor, String code, 
            String revision, String serial) {
        
        this.type = type;
        this.vendorID = vendor;
        this.productCode = code;
        this.revisionNB = revision;
        this.serialNB = serial;
        this.identified = true;
        
    }
    
    /*Says if a Can Open node is an ADC or not*/
    /*This method is adapted to the CAN-CBX-AI814; it could change.*/
    public boolean isADC() {
        return (type.equals("40191"));
    }
    
    /*Says if a Can Open node is a DAC or not*/
    /*This method is adapted to the CAN-CBX-AO412; it could change.*/
    public boolean isDAC() {
        return (type.equals("80191"));
    }
    
    /*Says if a Can Open node is a MAxonMotor or not*/
    public boolean isMaxonMotor() {
        return (type.equals("20192"));
    }
   
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Node ID= ");
        sb.append(nodeID);
        String dec = String.format(" (in decimal= %d)", Integer.parseInt(nodeID, 16));
        sb.append(dec);
        sb.append("/ type=");sb.append(getType());
        sb.append("/ vendor=");sb.append(getVendorID());
        sb.append("/ product code=");sb.append(getProductCode());
        sb.append("/ revision=");sb.append(getRevisionNB());
        sb.append("/ serial number=");sb.append(getSerialNB());
        return sb.toString();
    }

    
    
    
    
}
