package testbenchAPC

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.startup.CCSBuilder ;


import static org.lsst.gruth.jutils.MapArgs.*

CCSBuilder builder = ["APC test bench with 2 can bus"]

def loaderTcpProxyName = "loaderTcpProxy" // the name of the tcpProxy

builder.
        "Main Module" ( org.lsst.ccs.subsystems.fcs.testbench.APCTestBench2CanBusMain,
                argMap(a("name", "main"),
                        anInt("tickMillis", 1000),
                        ref("bridge"),
                        ref("bridgeToLoader"),
                        ref("thermometer"),
                        ref("led"),
                        ref("fakeLed"),
                        ref("fakeSensor")))
                 


            //begin description of Main submodules
            {       

                // Bridge
                bridge (anImpl(BridgeToHardware, BridgeToChanger),
                        argMap(aString("name", "bridge"),
                            anInt("tickMillis", 1000),
                            ref("tcpProxy"),
                            ref("ao412")
                            ))

                {//begin description of bridge0's children          

                        // tcp Proxy
                        tcpProxy (CanOpenProxy,
                                argMap(aString("name", "tcpProxy"),
                                    anInt("tickMillis", 1000),
                                    anInt("portNumber", 50000,[static:true, constraints:1024..99000]),
                                    //aString("myClientName","APCTestBenchWith2CANBus",[static:true]),
                                    aString("myClientName","TestBench",[static:true]),                                 
                                    anInt("hardwareBootTimeout",1000, [description:"A timeout for the harwdare booting process",constraints:1000..10000])))

                        // can open devices for changer devices (autochanger and carousel)
                        ao412 (CanOpenDAC, 
                                argMap(aString("name", "ao412"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","2"),
                                    aString("serialNB","c7c40227")))

                            
                }//end description of bridge0's children

                // Bridge to loader
                bridgeToLoader (anImpl(BridgeToHardware, BridgeToLoader),
                        argMap(aString("name", "bridgeToLoader"),
                            anInt("tickMillis", 1000),
                            //ref("tcpProxyLoader"),
                            ref(loaderTcpProxyName),
                            ref("ai814")))

                {//begin description of children of bridge to loader          

                        // tcp Proxy
                        loaderTcpProxy (LoaderCanOpenProxy,
                        //tcpProxyLoader (LoaderCanOpenProxy,
                        //loaderTcpProxyName (LoaderCanOpenProxy, //ne marche pas
                                //argMap(aString("name", "tcpProxyLoader"),
                                argMap(aString("name", loaderTcpProxyName),
                                    anInt("tickMillis", 1000),
                                    anInt("portNumber", 51000,[static:true, constraints:1024..99000]),
                                    aString("myClientName","TestBench",[static:true]),                                   
                                    anInt("hardwareBootTimeout",1000, [description:"A timeout for the harwdare booting process",constraints:1000..10000])))

                        // can open devices
                        ai814 (CanOpenADC, 
                                argMap(aString("name", "ai814"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","1"),
                                    aString("serialNB","c7c50331"),
                                    aString("transmissionType","1")))

                            
                }//end description of bridge1's children


                // thermometer description 
                thermometer (anImpl(Thermometer, CanOpenThermometer),
                        argMap( a("name", "thermometer"),
                                anInt("tickMillis",1000),
                                aString("adcName","ai814",[description:"The name of the ADC where this thermometer is plugged."]),
                                anInt("numOfAnalogInput","1", [description:"The numero of the input of ADC where this thermometer is plugged",constraints:1..8])))

                // fake Sensor description 
                fakeSensor (anImpl(Thermometer, CanOpenThermometer),
                        argMap( a("name", "fakeSensor"),
                                anInt("tickMillis",1000),
                                aString("adcName","ai814",[description:"The name of the ADC where this thermometer is plugged."]),
                                anInt("numOfAnalogInput","3",[description:"The numero of the input of ADC where this thermometer is plugged",constraints:1..8]))) 
    
                // led description 
                led (anImpl(Led, CanOpenLED),
                        argMap( a("name", "led"),
                                anInt("tickMillis",1000),
                                aString("dacName","ao412",[description:"The name of the DAC where this led is plugged."]),
                                anInt("outputNumero","1",[description:"The numero of the output of DAC where this led is plugged",constraints:1..4]))) 

                // fake led description 
                fakeLed (anImpl(Led, CanOpenLED),
                        argMap( a("name", "fakeLed"),
                                anInt("tickMillis",1000),
                                aString("dacName","ao412",[description:"The name of the DAC where this led is plugged."]),
                                anInt("outputNumero","2",[description:"The numero of the output of DAC where this led is plugged",constraints:1..4]))) 
                         

                
                

            }//end description of Main submodules

                


