package org.lsst.ccs.subsystems.fcs.common;



import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.NumericSensor;

/**
 * This is a model for the Latch which holds a filter on an autochanger's truck.
 * There is 2 trucks on the autochanger, so there is 2 latches : LatchX- and LatchX+
 * This class is used to factorise code between single-filter-test and final product
 * in the creation of the data published by a Latch.
 * @author virieux
 */
public interface FilterLatch {

        
        public String getName();
        
        public NumericSensor getLockSensor();
        
        public NumericSensor getUnlockSensor();
        
        public NumericSensor getFilterPresenceSensor();
        
        public LockStatus getLockStatus();
      
        public boolean isControllerInFault();
       

}
