package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public interface AutoChanger {
			
	public String goToPosition(double trucksPositionOnline) throws BadCommandException;

	//public String stop();

	public double getTrucksPosition();

	public Filter getFilterOnTrucks();

	public String moveFilterToOnline(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException;
	
	public String moveFilterToStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException;
	
	public String grabFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException;

	public String ungrabFilterAtStandby() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException;

	public String closeLatchesAtStandby() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException;
	
	public String openLatchesAtStandby() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException;

	public void locateTrucks();
        
        public boolean isAtStandby();
	
}
