/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

/**
 * This is a model for an Emergency message comming from the CANbus.
 * It's created by CanOPenProxy and proceeded by the CanOpenProxy's Observers.
 * see CanOpenErrorsTable
 * @author virieux
 */
public class EmergencyMessage {
    
    private final String tcpProxyName;
    private final String nodeID;
    private final String deviceName; 
    private final String deviceErrorCode; //see properties deviceErrorCodes
    private final String deviceErrorName;
    private final String errorRegisterCode; //see properties errorRegisterCodes
    private final String errorRegisterName;

    public EmergencyMessage(String tcpProxyName, String nodeID, String deviceName, String deviceErrorCode, 
            String deviceErrorName, String errorRegisterCode, String errorRegisterName) {
        this.tcpProxyName = tcpProxyName;
        this.nodeID = nodeID;
        this.deviceName = deviceName;
        this.deviceErrorCode = deviceErrorCode;
        this.deviceErrorName = deviceErrorName;
        this.errorRegisterCode = errorRegisterCode;
        this.errorRegisterName = errorRegisterName;
    }

    public String getTcpProxyName() {
        return tcpProxyName;
    }

    public String getNodeID() {
        return nodeID;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public String getDeviceErrorCode() {
        return deviceErrorCode;
    }

    public String getDeviceErrorName() {
        return deviceErrorName;
    }

    public String getErrorRegisterCode() {
        return errorRegisterCode;
    }

    public String getErrorRegisterName() {
        return errorRegisterName;
    }
    
    

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Emergency message received from CANbus");
        sb.append(" from tcpProxy=");sb.append(tcpProxyName);
        sb.append(" for nodeID=");sb.append(nodeID);
        sb.append(" deviceName=");sb.append(deviceName);
        sb.append(" deviceErrorCode=");sb.append(deviceErrorCode);
        sb.append(" deviceErrorName=");sb.append(deviceErrorName);
        sb.append(" errorRegisterCode=");sb.append(errorRegisterCode);
        sb.append(" errorRegisterName=");sb.append(errorRegisterName);
        return sb.toString();
    }
    
    
    
    
}
