/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and unlockClamps the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.MobileItemAction;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * The Three Online clamps which holds a filter when it is at ONLINE position can
 * ve viewed as a single object. 
 * It's the goal of this class to represent this
 * object. Opening or closing the 3 clamps at ONLINE is not the same 
 * action as opening or closing online clamps one by one.
 * @author virieux
 */
public class AutochangerThreeOnlineClamps extends MobileItemModule{

    AutoChangerModule autochanger;
    AutochangerOnlineClampModule onlineClampXminus;
    AutochangerOnlineClampModule onlineClampXplus;
    AutochangerOnlineClampModule onlineClampZ;
    
    private FcsEnumerations.LockStatus lockStatus;
    
    private volatile boolean initialized;
    
    final Condition stateUpdated = lock.newCondition();
    
     /* This is used when we update the clamps
    state with the values returned 
     *  by the sensors.
     */
    protected volatile boolean updatingState = false;
    
    long timeoutForLockingClamps, timeoutForUnlockingClamps;

    public AutochangerThreeOnlineClamps(String moduleName, int aTickMillis,
            AutochangerOnlineClampModule onlineClampXminus, 
            AutochangerOnlineClampModule onlineClampXplus, 
            AutochangerOnlineClampModule onlineClampZ,
            long timeoutForLockingClamps,
            long timeoutForUnlockingClamps) {
        super(moduleName, aTickMillis);
        this.onlineClampXminus = onlineClampXminus;
        this.onlineClampXplus = onlineClampXplus;
        this.onlineClampZ = onlineClampZ;
        this.timeoutForLockingClamps = timeoutForLockingClamps;
        this.timeoutForUnlockingClamps = timeoutForUnlockingClamps;
    }
    
    
    
    //TODO add constructor with the 3 onlineClamps

    public AutochangerOnlineClampModule getOnlineClampXminus() {
        return onlineClampXminus;
    }

    public AutochangerOnlineClampModule getOnlineClampXplus() {
        return onlineClampXplus;
    }

    public AutochangerOnlineClampModule getOnlineClampZ() {
        return onlineClampZ;
    }
    
    public EPOSController getOnlineClampXminusController() {
        return onlineClampXminus.getController();
    }
    
    public EPOSController getOnlineClampXplusController() {
        return onlineClampXplus.getController();
    } 
    
    public EPOSController getOnlineClampZController() {
        return onlineClampZ.getController();
    }  

    public FcsEnumerations.LockStatus getLockStatus() {
        return lockStatus;
    }
    
    
    
    @Override
    public void initModule() {
        this.autochanger = (AutoChangerModule) this.getModule("autochanger");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Override
    public boolean isHardwareReady() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, 
            description="Lock the online clamps.")
    public String lockClamps() throws BadCommandException, SDORequestException, 
            ErrorInCommandExecutionException, FcsHardwareException {
        return this.executeAction(MobileItemAction.LOCK_ONLINECLAMPS, timeoutForLockingClamps);
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, 
            description="Unlock the online clamps.")
    public String unlockClamps() throws BadCommandException, SDORequestException, 
            ErrorInCommandExecutionException, FcsHardwareException {
        return this.executeAction(MobileItemAction.UNLOCK_ONLINECLAMPS, timeoutForUnlockingClamps);
    }

    public StatusDataPublishedByAutochangerThreeClamps getStatusData() {
        return FcsUtils.createStatusDataPublishedByThreeClamps(this);
    }
   
    @Override
    public void publishData() {
        this.getSubsystem().publishStatus("autochangerClamps", getStatusData());
    }
    
    /**
     * This methods updates the whole autochanger state in reading all the sensors.
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Update autochanger state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        autochanger.updateStateWithSensors();
    }
    
    /**
     * This methods updates lockStatus from the values return by the sensors.
     * This values are given in an array of hexa values as arguments of the method.
     * @param hexaValues 
     */
     @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
             description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        lock.lock();
        try {
            updatingState = true;
            this.onlineClampXminus.updateStateWithSensors(hexaValues);
            this.onlineClampXplus.updateStateWithSensors(hexaValues);
            this.onlineClampZ.updateStateWithSensors(hexaValues);
            
            boolean inError = (onlineClampXminus.isInError()
                    || onlineClampXplus.isInError()
                    || onlineClampZ.isInError());
            
            boolean locked = (onlineClampXminus.isLocked()
                    || onlineClampXplus.isLocked()
                    || onlineClampZ.isLocked());
            
            boolean unlocked = (onlineClampXminus.isUnlocked()
                    || onlineClampXplus.isUnlocked()
                    || onlineClampZ.isUnlocked());
            
            boolean inTravel = (onlineClampXminus.isInTravel()
                    || onlineClampXplus.isInTravel()
                    || onlineClampZ.isInTravel());
            
            if (inError) {
                this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            } else if (locked) {    
                this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
            } else if (unlocked) {
                this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
            } else if (inTravel) {
                this.lockStatus = FcsEnumerations.LockStatus.INTRAVEL;
            } else {
                this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
            }
            
        } finally {

            updatingState = false;
            stateUpdated.signal();
            lock.unlock();
            this.publishData();
        }
    }
    
}
