/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and unlockClamps the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;


import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * This class is the Main Module when autochanger is in standalone mode.
 * @author virieux
 */
public class AutochangerMainModule extends MainModule {
    
    AutoChangerModule autochanger;
    InclinometerModule inclinometer;

    public AutochangerMainModule(String aName, int aTickMillis, 
            BridgeToHardware bridge) {
        super(aName, aTickMillis, bridge);
    }

    public AutochangerMainModule(String aName, int aTickMillis, 
            BridgeToHardware bridge,
            AutoChangerModule autochanger,
            InclinometerModule inclinometer) {
        super(aName, aTickMillis, bridge);
        this.autochanger = autochanger;
        this.inclinometer = inclinometer;
    }
    
    

    //for the GUI
    public AutoChangerModule getAutochanger() {
        return autochanger;
    }
    
    
    
    //for the GUI
    public EPOSController getLinearRailMasterController() {
        return autochanger.getTrucks().getLinearRailMasterController();
    }
    
    //for the GUI
    public EPOSController getLinearRailSlaveController() {
        return autochanger.getTrucks().getLinearRailSlaveController();
    }
   
    //for the GUI
    public EPOSController getLatchXminusController() {
        return autochanger.getLatches().getLatchXminusController();
    }

    public EPOSController getLatchXplusController() {
        return autochanger.getLatches().getLatchXplusController();
    }

    //For the GUI
    public PlutoGatewayModule getPlutoGateway() {
        return autochanger.getPlutoGateway();
    }
    
    public AutoChangerTrucksModule getAutochangerTrucks() {
        return autochanger.getTrucks();
    }

    public EPOSController getOnlineClampXminusController() {
        return autochanger.getOnlineClamps().getOnlineClampXminusController();
    }
    
    public EPOSController getOnlineClampXplusController() {
        return autochanger.getOnlineClamps().getOnlineClampXplusController();
    }
        
    public EPOSController getOnlineClampZController() {
        return autochanger.getOnlineClamps().getOnlineClampZController();
    }
    
     /**
     * For the GUI.
     * @return 
     */
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
            description="The GUIs need that for the initialization.")
    public AutochangerConfig getFullState() {
        try {
            return FcsUtils.createAutochangerConfig(this);
        } catch (Exception e) {
            log.error(e);
        }
        return null;           
    }

    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
        description="Update autochanger state in reading the sensors.")
    @Override
    public void updateStateWithSensors() 
            throws FcsHardwareException, ErrorInCommandExecutionException, 
            BadCommandException {
        super.updateStateWithSensors();
        autochanger.updateStateWithSensors();
    }
    

}
