// see documentation on single-filter-test on : https://confluence.slac.stanford.edu/display/LSSTCAM/Single+Filter+Test
package sft

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.singlefiltertest.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.startup.CCSBuilder ;


import static org.lsst.gruth.jutils.MapArgs.*
import static org.lsst.gruth.nodes.NodeUtils.loopList

//because in single-filter-test there is only one filter
def socketNumber = 1

//Carousel Can Open Devices (CAN-CBX-AI814)
def adcName = "ai814"

//Autochanger Can Open Devices
def dacName = "ao412"  // to control the latches actuator
def railsSensorsDIOName = "dio8n1"  // to control the trucks and monitor the rails sensors
def filterSensorsDIOName = "dio8n2" // to monitor the filter sensors

CCSBuilder builder = ["single filter test"]

builder.
        "Main Module" ( SftMainModule,
                argMap(a("name", "main"),
                        anInt("tickMillis", 3000),
                        ref("bridge"),
                        ref("dummyFilter")))
                 


            //begin description of Main submodules
            {       
                //-------------------------
                // BEGIN Bridge description
                // Bridge
                bridge (BridgeToCanOpenHardware,
                        argMap(aString("name", "bridge"),
                            anInt("tickMillis", 1000),
                            ref("tcpProxy"),
                            ref("ai814"),
                            ref("ao412"),
                            ref("dio8n1"),
                            ref("dio8n2"),
                            ref("clampActuatorXminus"),
                            ref("clampActuatorXplus")))

                {//begin description of bridge's children          

                        // tcp Proxy
                        tcpProxy (CanOpenProxy,
                                argMap(aString("name", "tcpProxy"),
                                    anInt("tickMillis", 1000),
                                    aString("myClientName","TestBench",[static:true]),
                                    anInt("expectedNodesNB", 6),
                                    anInt("portNumber", 50000,[static:true, constraints:1024..99000]),
                                    anInt("hardwareBootTimeout",2000, [description:"A timeout for the harwdare booting process",constraints:1000..10000])))

                        // can open devices
                        ai814 (CanOpenADC, 
                                argMap(aString("name", "ai814"),
                                    anInt("tickMillis", 3000),
                                    aString("nodeID","21"),
                                    aString("serialNB","c7c40234"),
                                    aString("transmissionType","1")))

                        ao412 (CanOpenDAC, 
                                argMap(aString("name", "ao412"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","22"),
                                    aString("serialNB","c7c60307")))

                        dio8n1 (CanOpenDIO,
                            argMap(a ("name", "dio8n1"),
                                anInt("tickMillis", 3000),
                                aString("nodeID", "23"),
                                aString("serialNB", "c7ca0914")))

                        dio8n2 (CanOpenDIO,
                                    argMap(a ("name", "dio8n2"),
                                    anInt("tickMillis", 3000),
                                    aString("nodeID", "24"),
                                    aString("serialNB", "c7ca0913")))

                        clampActuatorXminus (anImpl(Actuator, CanOpenClampActuatorModule),
                                argMap( a("name", "clampActuatorXminus"),
                                anInt("tickMillis",3000),
                                aString("nodeID","1a"),
                                anInt("serialNB",79003317),
                                aRef("motor","motorXminus"),
                                // an enum could have been directly handled
                                aString("mode", "CURRENT")))  
  
                            {//begin description of clampActuatorXminus's children

                                "motorXminus"(org.lsst.ccs.subsystems.fcs.drivers.Motor,
                                        argMap(a("name","motorXminus"),
                                                anInt("motorType",11),
                                                anInt("positionSensorType", 3),
                                                anInt("continuousCurrentLimit",2360),
                                                anInt("maxSpeedInCurrentMode", 25),
                                                anInt("thermalTimeConstantWinding", 160),
                                                anInt("outputCurrentLimit", 4720) ,
                                                anInt("polePairNumber", 8),
                                                anInt("currentValue", 1500),
                                                anInt("currentValueToMaintain", 200)))
                            }//end description of clampActuatorXminus's children

                        clampActuatorXplus (anImpl(Actuator, CanOpenClampActuatorModule),
                                argMap( a("name", "clampActuatorXplus"),
                                anInt("tickMillis",3000),
                                aString("nodeID","1b"),
                                anInt("serialNB",79003313),
                                aRef("motor","motorXplus"),
                                // an enum could have been directly handled
                                aString("mode", "CURRENT")))  
  
                            {//begin description of clampActuatorXplus's children

                                "motorXplus"(org.lsst.ccs.subsystems.fcs.drivers.Motor,
                                        argMap(a("name","motorXplus"),
                                                anInt("motorType",11),
                                                anInt("positionSensorType", 3),
                                                anInt("continuousCurrentLimit",2360),
                                                anInt("maxSpeedInCurrentMode", 25),
                                                anInt("thermalTimeConstantWinding", 160),
                                                anInt("outputCurrentLimit", 4720) ,
                                                anInt("polePairNumber", 8),
                                                anInt("currentValue", 1500),
                                                anInt("currentValueToMaintain", 200)))
                            }//end description of clampActuatorXplus's children

                            
                }//end description of bridge's children
                // END Bridge description
                // ------------------------

                //-------------------------
                // BEGIN Filter description

                dummyFilter (Filter, argMap(aString("name", "dummyFilter"))) //ok

                // END Filter description
                // ------------------------

                //----------------------------
                // BEGIN Carousel description
                carousel (anImpl(Carousel, SftCarouselModule),
                        argMap( a("name", "carousel"),
                                anInt("tickMillis",5000),
                                //use getChildren for following lines
                                aRef("carouselMotor", "simuCarouselMotor"),
                                //ref("clampActuatorXminus"),
                                //ref("clampActuatorXplus"),
                                aRef("brake", "carouselLatch"),
                                anInt("nbSockets", socketNumber) ,
                                a("sockets", loopList(socketNumber, {ref ("socket$it")})) ))
                        
                {//begin description of carousel's children

                    carouselLatch ( anImpl(GenericLatch,CarouselLatch),
                            argMap(aString("name", "carouselLatch")))

                    
                    //just to be compatible with the real carousel
                    simuCarouselMotor (anImpl(Motor,SimuCarouselMotor),
                            argMap( a("name", "simuCarouselMotor") ,
                                    anInt("tickMillis",3000),
                                    aString("serialNumber","CCS-FCS-simu-CarouselMotor-20100718-1"),
                                    aDbl("nominalVelocity",21.0),
                                    aDbl("maximalVelocity", 21.8 ))) // OK



                    /* macro generation of Sockets */
                    //for (int ix= 0; ix < socketNumber; ix++){
                    int ix = 0 ;
                        "socket$ix" ( CarouselSocket,
                                argMap(aDbl("position", "0.0"),
                                        aDbl("standbyPosition", "0.0"),
                                        aRef("clampXminus", "clampXminus"),
                                        aRef("clampXplus", "clampXplus")))

                                {   
                                    //-------------------------
                                    // BEGIN clampXminus description
                                    // TRANSITION no object numbering
                                    //"clampXminus$ix" (anImpl(FilterClampModule, SimuFilterClampXminusModule),
                                     "clampXminus" (anImpl(FilterClampModule, FilterClampXminusModule),
                                            //argMap( a("name", "clampXminus$ix"),
                                             argMap( a("name", "clampXminus"),
                                                    anInt("tickMillis",5000),
                                                    //ref("dummyFilter"),
                                                    // actuator clmapActuatorXminus
                                                    aRef("filterPresenceSensor","filterPresenceXminus"),
                                                     //aRef("filterPresenceSensor","filterPresenceXminus$ix"),
                                                    anInt("filterPositionValueA", 1500, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                                                    anInt("filterPositionValueB", 24400, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                                                    anInt("filterPositionValueC", 32000 , [description:"above valueC, there is NOFILTER",constraints:0..32768]),
                                                    aRef("lockSensor", "lockSensorXminus"),
                                                     //aRef("lockSensor", "lockSensorXminus$ix"),
                                                    anInt("lockSensorValueA", 5000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                                                    anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                                                    anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                                                    aRef("thermometer", "thermometerXminus")))
                                    {
                                        "filterPresenceXminus" (anImpl(Sensor14bits, CanOpenSensor14bits),
                                                argMap( a("name", "filterPresenceXminus"),
                                                    aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                    anInt("numOfAnalogInput",5, [description:"The numero of the input of ADC where this sensor is plugged",constraints:1..8])))


                                        "lockSensorXminus" (anImpl(Sensor14bits, CanOpenSensor14bits),
                                                argMap( a("name", "lockSensorXminus"),
                                                    aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                    anInt("numOfAnalogInput",7, [description:"The numero of the input of ADC where this sensor is plugged",constraints:1..8])))


                                        "thermometerXminus" ( CanOpenThermometer,
                                                argMap( a("name", "thermometerXminus"),
                                                    aString("adcName",adcName,[static:true,description:"The name of the ADC where this thermometer is plugged."]),
                                                    anInt("numOfAnalogInput","6", [description:"The numero of the input of ADC where this thermometer is plugged",constraints:1..8])))


                                    }.calls {
                                        it.setActuator(ref("clampActuatorXminus"))

                                    }
                                    //-------------------------
                                    // END clampXminus description

                                    //-------------------------
                                    // BEGIN clampXplus description
                                    // TRANSITION no object numbering
                                    //"clampXplus$ix" (anImpl(FilterClampModule, SimuFilterClampXminusModule),
                                    "clampXplus" (anImpl(FilterClampModule, FilterClampXplusModule),
                                            //argMap( a("name", "clampXplus$ix"),
                                            argMap( a("name", "clampXplus"),
                                                    anInt("tickMillis",5000),
                                                    //ref("dummyFilter"),
                                                    // actuator clmapAcutatorplusX
                                                    aRef("filterPresenceSensor","filterPresenceXplus"),
                                                    //aRef("filterPresenceSensor","filterPresenceXplus$ix"),
                                                    anInt("filterPositionValueA", 1355, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                                                    anInt("filterPositionValueB", 10500, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                                                    anInt("filterPositionValueC", 32000, [description:"above valueC, there is NOFILTER",constraints:0..32768] ),
                                                    aRef("lockSensor", "lockSensorXplus"),
                                                    //aRef("lockSensor", "lockSensorXminus$ix"),
                                                    anInt("lockSensorValueA", 6000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                                                    anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                                                    anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                                                    aRef("thermometer", "thermometerXplus")))
                                    {
                                        "filterPresenceXplus" (anImpl(Sensor14bits, CanOpenSensor14bits),
                                                argMap( a("name", "filterPresenceXplus"),
                                                        aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                        anInt("numOfAnalogInput",1,[description:"The numero of the input of ADC where this sensor is plugged",constraints:1..8])))


                                        "lockSensorXplus" (anImpl(Sensor14bits, CanOpenSensor14bits),
                                                argMap( a("name", "lockSensorXplus"),
                                                        aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                        anInt("numOfAnalogInput",3,[description:"The numero of the input of ADC where this sensor is plugged",constraints:1..8])))


                                        "thermometerXplus" ( CanOpenThermometer,
                                                argMap( a("name", "thermometerXplus"),
                                                        aString("adcName",adcName,[static:true,description:"The name of the ADC where this thermometer is plugged."]),
                                                        anInt("numOfAnalogInput",2,[description:"The numero of the input of ADC where this thermometer is plugged",constraints:1..8])))

                                    }.calls {
                                        it.setActuator(ref("clampActuatorXplus"))
                                    }
                                    //-------------------------
                                    // END clampXplus description
                                }
                     /*}*/  //For

                }.calls {
                    // no more? it.listens (ref("simuCarouselMotor"))
                    // simulation context only ? YES !
                    //for(int ix=0; ix< socketNumber ; ix++) {
                        it.listens(ref("clampXplus"), ref("clampXminus"))
                    //}
                }//end description of clampActuatorXplus's children
                //END Carousel description
                // ------------------------

                // ------------------------
                //BEGIN AUTO CHANGER
                autochanger (SftAutoChangerModule,
                        argMap( a("name", "autochanger"),
                                anInt("tickMillis",5000),
                                anInt("timeToConfortAPosition",5000),
                                anInt("timeToGoToStandby",30000),
                                anInt("timeToGoToStandback",30000),
                                aString("railsSensorsDIOName",railsSensorsDIOName,[description:"The name of the DIO where the rails sensors are plugged."]),
                                aString("filterSensorsDIOName",filterSensorsDIOName,[description:"The name of the DIO where the filter sensors are plugged."]),
                                ref("sftTrucksMotor"),
                                ref("latchXminus"),
                                ref("latchXplus"),
                                ref("truckXminus"),
                                ref("truckXplus")))
                        
                {//begin description of autochanger's children

                    // ------------------------
                    //BEGIN  SFT TRUCKS MOTOR (AUTOCHANGER)
                    sftTrucksMotor(anImpl(SftTruckMotor, CanOpenTruckMotor),
                            argMap( a("name","sftTrucksMotor"),
                                    anInt("tickMillis", 5000),
                                    aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) which controls this motor."]),
                                    anInt("outputNumeroToStandby",2,[description:"The numero of the output of DIO where we send a current for the trucks to go to standby",constraints:1..8]),
                                    anInt("outputNumeroToStandback",1,[description:"The numero of the output of DIO where we send a current for the trucks to go to standback",constraints:1..8]) )) //OK

                    //END  SFT TRUCKS MOTOR
                    // ------------------------



                    // ------------------------
                    //BEGIN  latchMinux    (AUTOCHANGER)
                    "latchXminus" (anImpl(FilterLatch, FilterLatchModule),
                        argMap( a ("name", "latchXminus") ,
                                anInt("tickMillis", 5000),
                                //aBool("locked")
                                aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                                aRef("lockSensor","lockSensorLatchXminus"),
                                aRef("unlockSensor","unlockSensorLatchXminus"),
                                aRef("filterPresenceSensor","filterPresenceSensorLatchXminus"),
                                aRef("latchActuator","latchActuatorXminus")))
                        {
                            "lockSensorLatchXminus" ( anImpl( NumericSensor,CanOpenNumericSensor) ,
                                argMap(a ("name", "lockSensorLatchXminus") ,
                                    aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))

                            "unlockSensorLatchXminus" ( anImpl( NumericSensor,CanOpenNumericSensor) ,
                                argMap( a("name", "unlockSensorLatchXminus"),
                                    aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                            "filterPresenceSensorLatchXminus" ( anImpl( NumericSensor,CanOpenNumericSensor) ,
                                argMap( a("name", "filterPresenceSensorLatchXminus") ,
                                    aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                            "latchActuatorXminus" (
                                    anImpl(Actuator, CanOpenLatchActuatorModule),
                                    argMap(a("name", "latchActuatorXminus") ,
                                            anInt("tickMillis", 1000),
                                            aString("dacName",dacName,[static:true,description:"The name of the DAC where this actuator is plugged."]),
                                            anInt("numOfAnalogOutputForSpeedVoltage", 1),
                                            anInt("numOfAnalogOutputForCurrentLimit", 2),
                                            anInt("speedVoltageInVolt", 4,[description:"decimal value of the voltage (in Volt) to send to the actuator to determine the speed",constraints:-10..10]),
                                            aDbl("currentLimitInVolt", 0.150,[description:"decimal value of the current limit (in Ampere) to determine the couple"]),
                                            anInt("speedVoltageMaxValue", 10, [description:"maximal decimal value of the speed voltage"]),
                                            anInt("speedVoltageMinValue", -10,[description:"minimal decimal value of the speed voltage"])))
                        }
                        // ------------------------
                        //END  latchXminus    (AUTOCHANGER)

                        // ------------------------
                        //BEGIN  latchXplus    (AUTOCHANGER)
                        "latchXplus" (anImpl(FilterLatch, FilterLatchModule),
                                argMap( a ("name", "latchXplus") ,
                                        anInt("tickMillis", 5000),
                                        aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                                        aRef("lockSensor","lockSensorLatchXplus"),
                                        aRef("unlockSensor","unlockSensorLatchXplus"),
                                        aRef("filterPresenceSensor","filterPresenceSensorLatchXplus"),
                                        aRef("latchActuator","latchActuatorXplus")))

                                {
                                    "lockSensorLatchXplus" ( anImpl( NumericSensor,CanOpenNumericSensor) ,
                                        argMap(a ("name", "lockSensorLatchXplus") ,
                                            aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 6, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                                    "unlockSensorLatchXplus" ( anImpl( NumericSensor,CanOpenNumericSensor) ,
                                            argMap( a("name", "unlockSensorLatchXplus"),
                                                aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                                anInt("inputNumero", 7, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                                    "filterPresenceSensorLatchXplus" ( anImpl( NumericSensor,CanOpenNumericSensor) ,
                                            argMap( a("name", "filterPresenceSensorLatchXplus") ,
                                                aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                                anInt("inputNumero", 5, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                                    "latchActuatorXplus" (
                                            anImpl(Actuator, CanOpenLatchActuatorModule),
                                            argMap(a("name", "latchActuatorXplus") ,
                                                aString("dacName",dacName,[static:true,description:"The name of the DAC where this actuator is plugged."]),
                                                anInt("tickMillis", 3000),
                                                anInt("numOfAnalogOutputForSpeedVoltage", 3),
                                                anInt("numOfAnalogOutputForCurrentLimit", 4),
                                                anInt("speedVoltageInVolt", 4,[description:"decimal value of the voltage (in Volt) to send to the actuator to determine the speed",constraints:-10..10]),
                                                aDbl("currentLimitInVolt", 0.150),
                                                anInt("speedVoltageMaxValue", 10),
                                                anInt("speedVoltageMinValue", -10)))

                                }
                                //END  LATCH   (AUTOCHANGER)
                                // ------------------------

                        // ------------------------
                        //BEGIN  TRUCK   (AUTOCHANGER)
                        "truckXminus" (  TruckModule ,
                            argMap(  a("name", "truckXminus") ,
                                        anInt("tickMillis", 3000),
                                        aRef("railSensorStandby", "railSensorStandbyXminus") ,
                                        aRef("railSensorStandback", "railSensorStandbackXminus") ))
                           {
                               "railSensorStandbyXminus" (  anImpl(NumericSensor, CanOpenNumericSensor) ,
                                    argMap( a("name", "railSensorStandbyXminus"),
                                        aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                        anInt("inputNumero", 6 , [description:"The numero of the input of the DIO where this sensor is plugged."]) ))

                               "railSensorStandbackXminus" (  anImpl(NumericSensor , CanOpenNumericSensor) ,
                                       argMap( a("name", "railSensorStandbackXminus"),
                                           aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                           anInt("inputNumero", 5, [description:"The numero of the input of the DIO where this sensor is plugged."]) ))
                           }

                        "truckXplus" (  TruckModule ,
                            argMap(  a("name", "truckXplus") ,
                                    anInt("tickMillis", 3000),
                                    aRef("railSensorStandby", "railSensorStandbyXplus") ,
                                    aRef("railSensorStandback", "railSensorStandbackXplus") ))
                            {
                                "railSensorStandbyXplus" (  anImpl(NumericSensor, CanOpenNumericSensor) ,
                                        argMap( a("name", "railSensorStandbyXplus"),
                                            aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                            anInt("inputNumero", 8, [description:"The numero of the input of the DIO where this sensor is plugged."] ) ))


                                "railSensorStandbackXplus" (  anImpl(NumericSensor , CanOpenNumericSensor) ,
                                        argMap( a("name", "railSensorStandbackXplus"),
                                            aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                            anInt("inputNumero", 7, [description:"The numero of the input of the DIO where this sensor is plugged."]) ))

                            }
                        //END  TRUCK   (AUTOCHANGER)
                        // ------------------------


//                }.calls {
//                    //it.listens(ref("sftTrucksMotor"))

                }
                //END AUTO CHANGER
                // ------------------------           

                
                
            //end description of Main submodules
            }.calls {
            it.listens (ref("carousel"), ref("autochanger"))
            }    // main ok

                


