/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentError;

public class BridgeForAPCTestBench
extends BridgeToCanOpenHardware {
    @Override
    public void initModule() {
        Module.log.debug((Object)("INIT MODULE" + this.getName()));
        PieceOfHardware[] hardwareList = new PieceOfHardware[]{this.ai814, this.ao412};
        this.tcpProxy.hardwareList = hardwareList;
        int numberOfNodes = hardwareList.length;
        this.tcpProxy.setExpectedNodesNB(numberOfNodes);
        Module.log.debug((Object)("Number of pieces of hardware expected =" + numberOfNodes));
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        }
        catch (DeploymentError ex) {
            Module.log.error((Object)(String.valueOf(ex.getMessage()) + ": Could not load CanOpen Error Tables"));
            this.getSubsystem().updateState(State.InError, "Could not load CanOpen Error Tables");
        }
    }
}

