/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.localdb.Trending;
import org.lsst.ccs.subsystems.fcs.Thermometer;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareError;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.ReadingADCError;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;
import org.lsst.ccs.subsystems.fcs.testbench.CanOpenLED;

public class APCTestBenchMainModule
extends Module {
    private BridgeToHardware bridge;
    private Thermometer thermometer;
    private CanOpenLED led;
    private CanOpenLED fakeLed;
    private Thermometer fakeSensor;
    @Trending
    public double temperature;

    public BridgeToHardware getBridge() {
        return this.bridge;
    }

    public void setBridge(BridgeToHardware bridge) {
        this.bridge = bridge;
    }

    public Thermometer getThermometer() {
        return this.thermometer;
    }

    public void setThermometer(Thermometer thermometer) {
        this.thermometer = thermometer;
    }

    public CanOpenLED getLed() {
        return this.led;
    }

    public void setLed(CanOpenLED led) {
        this.led = led;
    }

    public CanOpenLED getFakeLed() {
        return this.fakeLed;
    }

    public void setFakeLed(CanOpenLED fakeLed) {
        this.fakeLed = fakeLed;
    }

    public Thermometer getFakeSensor() {
        return this.fakeSensor;
    }

    public void setFakeSensor(Thermometer fakeSensor) {
        this.fakeSensor = fakeSensor;
    }

    public int getReturnValue(String responseLine, int inputNB) throws ReadingADCError {
        if (inputNB < 1 || inputNB > 8) {
            throw new IllegalArgumentException();
        }
        String[] words = responseLine.split(",");
        String cfr_ignored_0 = words[0];
        Module.log.debug((Object)("Value in HEXA:" + words[inputNB]));
        int value = Integer.parseInt(words[inputNB], 16);
        Module.log.debug((Object)("Value in decimal:" + words[inputNB]));
        return value;
    }

    public double readTemperature() throws HardwareError {
        return this.thermometer.readTemperature();
    }

    public double readTemperatureFromPDO() throws HardwareError, BadCommandException {
        CanOpenProxy.PDOStorage pdoStore = this.bridge.readPDOs();
        return this.thermometer.readTemperatureWithPDO(pdoStore);
    }

    public String turnOnLED() throws SDORequestError, HardwareNotDetectedException {
        return this.led.turnON();
    }

    public String turnOffLED() throws SDORequestError, HardwareNotDetectedException {
        return this.led.turnOFF();
    }

    public String turnOnFakeLED() throws SDORequestError, HardwareNotDetectedException {
        return this.fakeLed.turnON();
    }

    public String turnOffFakeLED() throws SDORequestError, HardwareNotDetectedException {
        return this.fakeLed.turnOFF();
    }

    public double readFakeSensor() throws HardwareError, BadCommandException {
        CanOpenProxy.PDOStorage pdoStore = this.bridge.readPDOs();
        return this.fakeSensor.readTemperatureWithPDO(pdoStore);
    }

    public void initModule() {
        String channelName = "temperature";
        String tempLow = String.valueOf(20.0);
        String tempHigh = String.valueOf(25.0);
        this.getSubsystem().publishMetaData(channelName, "tempLow", tempLow);
        this.getSubsystem().publishMetaData(channelName, "tempHigh", tempHigh);
        this.getSubsystem().publishMetaData("fakeTemperature", "fakeTempLow", tempLow);
        this.getSubsystem().publishMetaData("fakeTemperature", "fakeTempHigh", tempHigh);
        this.getSubsystem().publishMetaData("bidon", "ici", "maintenant");
    }

    public void tick() {
        try {
            this.temperature = this.readTemperatureFromPDO();
            Module.log.debug((Object)("TEMPERATURE=" + this.temperature));
            this.getSubsystem().publishData("temperature", (Object)this.temperature);
            double fakeTemperature = this.readFakeSensor();
            this.getSubsystem().publishData("fakeTemperature", (Object)fakeTemperature);
            this.getSubsystem().publishData("bidon", (Object)"coucou");
        }
        catch (HardwareError ex) {
            Module.log.error((Object)("ERROR in reading temperature" + ex.getMessage()));
        }
        catch (BadCommandException ex) {
            Module.log.error((Object)("ERROR in reading temperature" + ex.getMessage()));
        }
    }
}

