/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenError;
import org.lsst.ccs.subsystems.fcs.simulation.SimuClampFilterPresenceSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCompactIOModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuFilterClampModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;

public class SimuTruckMotorModule
extends SftTruckMotor {
    private SftAutoChangerModule autochanger;
    private SimuFilterClampModule clampXminus;
    private SimuFilterClampModule clampXplus;

    public void initModule() {
        this.autochanger = (SftAutoChangerModule)this.getModule("autochanger");
        this.clampXminus = (SimuFilterClampModule)this.getModule("clampXminus");
        this.clampXplus = (SimuFilterClampModule)this.getModule("clampXplus");
    }

    @Override
    public String moveToStandback() throws CanOpenError {
        if (this.autochanger.isAtStandby()) {
            this.setMovingToStandback(true);
            long timeToGo = this.autochanger.getTimeToGoToStandback();
            try {
                Module.log.debug((Object)(String.valueOf(this.getName()) + ": Waiting for the motor to go to STANDBACK"));
                Thread.sleep(timeToGo);
            }
            catch (InterruptedException ex) {
                Module.log.debug((Object)ex);
            }
            this.setMovingToStandback(false);
            SimuCompactIOModule simuRailsSensors = (SimuCompactIOModule)this.autochanger.getRailsSensorsDIO();
            simuRailsSensors.setHexaValue("50");
            SimuCompactIOModule simuFilterSensors = (SimuCompactIOModule)this.autochanger.getFilterSensorsDIO();
            if (this.autochanger.isTrucksEmpty()) {
                simuFilterSensors.simulateFilterPresenceInLatches("0");
            } else {
                ((SimuClampFilterPresenceSensor)this.clampXminus.getFilterPresenceSensor()).simulateNoFilter(this.clampXminus);
                ((SimuClampFilterPresenceSensor)this.clampXplus.getFilterPresenceSensor()).simulateNoFilter(this.clampXplus);
                Module.log.debug((Object)"====> END OF moveToStandback");
            }
        }
        return "Trucks are At Standback.";
    }

    @Override
    public String moveToStandby() throws CanOpenError {
        if (this.autochanger.isAtStandback()) {
            this.setMovingToStandby(true);
            long timeToGo = this.autochanger.getTimeToGoToStandby();
            try {
                Module.log.debug((Object)(String.valueOf(this.getName()) + ": Waiting for the motor to go to STANDBY"));
                Thread.sleep(timeToGo);
            }
            catch (InterruptedException ex) {
                Module.log.debug((Object)ex);
            }
            this.setMovingToStandby(false);
            SimuCompactIOModule simuRailsSensor = (SimuCompactIOModule)this.autochanger.getRailsSensorsDIO();
            simuRailsSensor.setHexaValue("A0");
            SimuCompactIOModule simuFilterSensors = (SimuCompactIOModule)this.autochanger.getFilterSensorsDIO();
            if (this.autochanger.isTrucksEmpty()) {
                simuFilterSensors.simulateFilterPresenceInLatches("1");
            } else {
                ((SimuClampFilterPresenceSensor)this.clampXminus.getFilterPresenceSensor()).simulateFilterIsLockable(this.clampXminus);
                ((SimuClampFilterPresenceSensor)this.clampXplus.getFilterPresenceSensor()).simulateFilterIsLockable(this.clampXplus);
                ((SimuClampLockSensor)this.clampXminus.getLockSensor()).simulateClampIsLOCKED(this.clampXminus);
                ((SimuClampLockSensor)this.clampXplus.getLockSensor()).simulateClampIsLOCKED(this.clampXplus);
            }
        }
        return "Trucks are At Standby.";
    }

    @Override
    public String off() throws CanOpenError {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return "Trucks motor is OFF";
    }
}

