/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.math.BigDecimal;
import java.util.Random;
import org.lsst.ccs.subsystems.fcs.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

public class SimuSensor14bits
extends Sensor14bits {
    int value1 = Sensor14bits.minValue;
    int value2 = Sensor14bits.maxValue;
    Random randomGenerator = new Random();

    public SimuSensor14bits() {
    }

    SimuSensor14bits(int aValue1, int aValue2) {
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    void setNewRange(int aValue1, int aValue2) {
        if (aValue2 < aValue1 || aValue2 > Sensor14bits.maxValue) {
            String message = String.format("we must have : value1 < value2 < maxValue / value1= %s, value2=%s, maxValue=%s", this.value1, this.value2, Sensor14bits.maxValue);
            throw new IllegalArgumentException(message);
        }
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    @Override
    public int readNewValue() {
        int n = this.randomGenerator.nextInt(this.value2);
        if (n > this.value1) {
            return n;
        }
        BigDecimal bd = new BigDecimal(this.value1 + n * (this.value2 - this.value1) / this.value2);
        return bd.intValue();
    }

    @Override
    public int updateValue(CanOpenProxy.PDOStorage pdoStorage) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

