/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.proxies.HardwareControlNotReady;
import org.lsst.ccs.subsystems.fcs.drivers.CommandDispenser;
import org.lsst.ccs.utilities.beanutils.WrappedException;

abstract class FcsTcpProxy
extends Module {
    private int portNumber = 50000;
    private Subsystem subsystem;
    private ServerSocket serverSock;
    private Thread readerThread;
    private volatile boolean stopped = false;
    private ClientContext clientContext;
    private CommandDispenser commandDispenser;
    final Lock lock = new ReentrantLock();
    final Condition aClientIsConnected = this.lock.newCondition();

    FcsTcpProxy() {
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void initModule() {
        this.commandDispenser = new CommandDispenser();
        try {
            this.serverSock = new ServerSocket(this.portNumber);
            Module.log.debug((Object)("SERVER STARTED ON PORT:" + this.portNumber));
        }
        catch (IOException e) {
            Module.log.debug((Object)"server not started", (Throwable)e);
            throw new WrappedException((Throwable)e);
        }
        try {
            Module.log.debug((Object)"WAITING FOR C-WRAPPER CLIENT...");
            Socket sock = this.serverSock.accept();
            Module.log.debug((Object)("socket accept on " + this.portNumber));
            BufferedReader reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), "ISO-8859-1"), 256);
            String nameAndProtocol = reader.readLine();
            String[] words = nameAndProtocol.split(" ");
            String cname = words[0];
            this.clientContext = new ClientContext(cname, sock, reader, sock.getOutputStream());
            Module.log.debug((Object)("REGISTERED : " + cname));
        }
        catch (IOException e) {
            Module.log.warn((Object)(" unexpected " + e));
        }
        this.startTheadReader();
    }

    protected void startTheadReader() {
        Runnable readingFromTcpProxy = new Runnable(){

            @Override
            public void run() {
                while (!FcsTcpProxy.this.stopped) {
                    try {
                        String readline = ((FcsTcpProxy)FcsTcpProxy.this).clientContext.reader.readLine();
                        FcsTcpProxy.access$0().debug((Object)("message read from tcpProxy=" + readline));
                        if (readline.startsWith("emcy")) {
                            FcsTcpProxy.this.processEmcyMessage(readline);
                            continue;
                        }
                        if (readline.startsWith("Unknown")) {
                            FcsTcpProxy.this.processUnknownCommand(readline);
                            continue;
                        }
                        String[] words = readline.split(",");
                        String commandWord = words[0];
                        String nodeID = words[1];
                        if (commandWord.equals("boot")) {
                            FcsTcpProxy.access$0().debug((Object)("boot command received for node: " + nodeID));
                            FcsTcpProxy.this.processBootMessage(nodeID);
                            continue;
                        }
                        String token = String.valueOf(commandWord) + nodeID;
                        token = readline.startsWith("sync") ? "sync" : String.valueOf(commandWord) + nodeID;
                        FcsTcpProxy.access$0().debug((Object)("Corresponding token=" + token));
                        if (FcsTcpProxy.this.commandDispenser.isTokenUsed(token)) {
                            FcsTcpProxy.access$0().debug((Object)("Response to a registred command:" + readline));
                            try {
                                FcsTcpProxy.this.commandDispenser.registerResponse(token, readline);
                            }
                            catch (Exception ex) {
                                FcsTcpProxy.access$0().error((Object)("Error in registering response to command :" + readline), ex.getCause());
                            }
                            continue;
                        }
                        FcsTcpProxy.access$0().debug((Object)("Unsynchronous message read from tcpProxy=" + readline));
                    }
                    catch (IOException iOException) {
                        FcsTcpProxy.access$0().error((Object)"Error in Thread reading from the tcp client.");
                    }
                }
            }
        };
        Module.log.debug((Object)"STARTING Thread reader");
        this.readerThread = new Thread(readingFromTcpProxy);
        this.readerThread.start();
    }

    public void stop() {
        this.stopped = true;
        this.readerThread.interrupt();
        try {
            this.clientContext.reader.close();
            this.clientContext.writer.close();
            this.clientContext.socket.close();
        }
        catch (Exception exception) {
            System.out.println("todo: ");
        }
        try {
            Thread.currentThread().interrupt();
            this.getSubsystem().shutdown();
        }
        catch (Exception exc) {
            Module.log.error((Object)("todo: change this!!!" + exc));
        }
        Thread.currentThread().interrupt();
        System.exit(0);
    }

    public synchronized boolean isReady(String clientName) {
        if (clientName == null) {
            throw new IllegalArgumentException("Client name can't be null.");
        }
        if (this.clientContext == null || this.clientContext.clientName == null) {
            return false;
        }
        return this.clientContext.clientName.equals(clientName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(String clientName, String command) throws TimeoutException {
        Module.log.debug((Object)(" CALL :" + clientName + " " + command));
        if (this.clientContext == null) {
            throw new HardwareControlNotReady(clientName);
        }
        if (this.stopped) {
            throw new IllegalStateException("textTCP module stopped");
        }
        try {
            String sentCommand = String.valueOf(command) + "\r\u0000\n";
            this.clientContext.writer.write(sentCommand, 0, sentCommand.length());
            this.clientContext.writer.flush();
            if (!(command.startsWith("rsdo") || command.startsWith("wsdo") || command.startsWith("info") || command.startsWith("sync"))) {
                if (!command.startsWith("srtr")) return "asynchronous command sent:" + command;
            }
            String commandToken = this.commandDispenser.register(command);
            try {
                long timeout = 5 * this.tickMillis;
                String string = this.commandDispenser.getCommandResponse(commandToken, timeout);
                return string;
            }
            catch (TimeoutException timeoutException) {
                Module.log.error((Object)(" ERROR in tcpProxy call method for command :" + command));
                throw new TimeoutException("TIMEOUT expired in tcpProxy call method for command :" + command);
            }
            finally {
                this.commandDispenser.remove(commandToken);
            }
        }
        catch (IOException e) {
            Module.log.error((Object)" ERROR in tcpProxy call method");
            throw new WrappedException(" ERROR in tcpProxy call method " + clientName, (Throwable)e);
        }
    }

    abstract void processBootMessage(String var1);

    abstract void processEmcyMessage(String var1);

    abstract void processUnknownCommand(String var1);

    static /* synthetic */ Logger access$0() {
        return Module.log;
    }

    protected class ClientContext {
        String clientName;
        BufferedReader reader;
        BufferedWriter writer;
        Socket socket;
        int token;

        ClientContext(String name, Socket socket, BufferedReader reader, OutputStream os) {
            try {
                this.clientName = name;
                this.reader = reader;
                this.socket = socket;
                this.writer = new BufferedWriter(new OutputStreamWriter(os, "ISO-8859-1"), 256);
            }
            catch (UnsupportedEncodingException e) {
                FcsTcpProxy.access$0().error((Object)"context not started", (Throwable)e);
                throw new Error(e);
            }
        }
    }
}

