/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.HardwareError;

public class CanOpenThermometer
extends CanOpenSensor14bits
implements Thermometer {
    public static double getDoubleValue(String valueInHexa) {
        double temp = 0.0;
        Module.log.debug((Object)("Value in HEXA=" + valueInHexa));
        int valueInt = Integer.parseInt(valueInHexa, 16);
        double voltage = (double)valueInt * 0.3125;
        Module.log.debug((Object)("Input Value read on the ADC:" + valueInt));
        Module.log.debug((Object)("Voltage = " + voltage + " volts"));
        temp = voltage / 10.0 - 273.15;
        return temp;
    }

    @Override
    public double readTemperature() throws HardwareError {
        String hexa = this.adc.readAnalogInput(this.numOfAnalogInput);
        return CanOpenThermometer.getDoubleValue(hexa);
    }

    @Override
    public double readTemperatureWithPDO(CanOpenProxy.PDOStorage pdo) throws BadCommandException {
        if (!this.adc.isInitalized()) {
            throw new BadCommandException("Can't read temperature from PDO if Can Open device is not initialized.");
        }
        if (!this.adc.transmissionType.equals("1")) {
            throw new BadCommandException("Transmission type for Can Open device must be 1");
        }
        String hexa = pdo.getVarValue(this.adc.nodeID, Integer.toString(this.numOfAnalogInput));
        return CanOpenThermometer.getDoubleValue(hexa);
    }
}

