/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.errors.HardwareError;

public class CanOpenLatchActuatorModule
extends LatchActuatorModule {
    CanOpenDAC dac;
    String dacName;
    int numOfAnalogOutputForSpeedVoltage;
    int numOfAnalogOutputForCurrentLimit;

    public int getNumOfAnalogOutputForSpeedVoltage() {
        return this.numOfAnalogOutputForSpeedVoltage;
    }

    public void setNumOfAnalogOutputForSpeedVoltage(int numOfAnalogOutputForSpeedVoltage) {
        this.numOfAnalogOutputForSpeedVoltage = numOfAnalogOutputForSpeedVoltage;
    }

    public int getNumOfAnalogOutputForCurrentLimit() {
        return this.numOfAnalogOutputForCurrentLimit;
    }

    public void setNumOfAnalogOutputForCurrentLimit(int numOfAnalogOutputForCurrentLimit) {
        this.numOfAnalogOutputForCurrentLimit = numOfAnalogOutputForCurrentLimit;
    }

    public CanOpenDAC getDac() {
        return this.dac;
    }

    public void setDac(CanOpenDAC dac) {
        this.dac = dac;
    }

    public void initModule() {
        this.dac = (CanOpenDAC)this.getModule(this.dacName);
    }

    @Override
    public String open() throws BadCommandException, ErrorInCommandExecutionException, HardwareError {
        int currentLimitInDecimal = (int)(this.getCurrentLimitInVolt() * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, currentLimitInDecimal);
        int speedVoltageInDecimal = (int)((double)this.getSpeedVoltageInVolt() * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, speedVoltageInDecimal);
        return String.valueOf(this.getName()) + " is OPEN";
    }

    @Override
    public String close() throws BadCommandException, ErrorInCommandExecutionException, HardwareError {
        int currentLimitInDecimal = (int)(this.getCurrentLimitInVolt() * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, currentLimitInDecimal);
        int speedVoltageInDecimal = (int)((double)this.getSpeedVoltageInVolt() * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, -speedVoltageInDecimal);
        return String.valueOf(this.getName()) + " is CLOSED";
    }

    @Override
    public String powerOff() throws BadCommandException, ErrorInCommandExecutionException, HardwareError {
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, 0);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, 0);
        return String.valueOf(this.getName()) + " is POWER OFF";
    }
}

