/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

public class CanOpenDevice
extends Module
implements PieceOfHardware {
    CanOpenProxy tcpProxy;
    String serialNB;
    String nodeID;
    boolean initialized;

    public CanOpenDevice() {
    }

    public CanOpenDevice(String serialNB, String nodeID) {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
        this.serialNB = serialNB;
        this.nodeID = nodeID;
        this.initialized = false;
    }

    @Override
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public void setSerialNB(String serialNB) {
        this.serialNB = serialNB;
    }

    @Override
    public boolean isNodeIdBootedAndOK() {
        return this.tcpProxy.isNodeIdBootedAndOK(this);
    }

    @Override
    public boolean isInitalized() {
        return this.initialized;
    }

    public void initModule() {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
    }

    @Override
    public String initializeHardware() throws Exception {
        this.initialized = true;
        return String.valueOf(this.getName()) + ": no hardware initialization for this device to be done.";
    }

    public String writeSDO(String index, String subindex, String length, String newValue) throws SDORequestError {
        return this.tcpProxy.writeSDO(this.nodeID, index, subindex, length, newValue);
    }

    public String readSDO(String index, String subindex) throws SDORequestError {
        return this.tcpProxy.readSDO(this.nodeID, index, subindex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/");
        sb.append(this.serialNB);
        sb.append("/NodeID_in_hexa=");
        sb.append(this.nodeID);
        int x = Integer.parseInt(this.nodeID, 16);
        sb.append("/NodeID_in_decimal=");
        sb.append(x);
        sb.append("/");
        if (this.tcpProxy == null) {
            return sb.toString();
        }
        if (this.isNodeIdBootedAndOK()) {
            sb.append("is booted/");
        } else {
            sb.append("ERROR/");
        }
        return sb.toString();
    }
}

