/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.ClampActuatorModule;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.Motor;
import org.lsst.ccs.subsystems.fcs.errors.ClampMotorConfigurationError;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestError;

public class CanOpenClampActuatorModule
extends ClampActuatorModule
implements PieceOfHardware {
    CanOpenProxy tcpProxy;
    private String nodeID;
    private String serialNB;
    private boolean initialized;
    private ActuatorMode mode;
    private Motor motor;
    final Lock lock = new ReentrantLock();
    final Condition enablingCompleted = this.lock.newCondition();
    protected volatile boolean enabling = false;

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    public String getSerialNB() {
        return this.serialNB;
    }

    public void setSerialNB(String serialNB) {
        this.serialNB = serialNB;
    }

    public Motor getMotor() {
        return this.motor;
    }

    public void setMotor(Motor motor) {
        this.motor = motor;
    }

    public String getMode() {
        return this.mode.toString();
    }

    public void setMode(String modeInString) {
        this.mode = ActuatorMode.valueOf(modeInString);
    }

    public CanOpenClampActuatorModule() {
    }

    public CanOpenClampActuatorModule(String nodeID, int inputID, String serial, Motor motor) {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
        this.nodeID = nodeID;
        this.serialNB = serial;
        this.initialized = false;
        this.mode = ActuatorMode.CURRENT;
        this.motor = motor;
    }

    @Override
    public boolean isNodeIdBootedAndOK() {
        return this.tcpProxy.isNodeIdBootedAndOK(this);
    }

    @Override
    public boolean isInitalized() {
        return this.initialized;
    }

    public void updateReadValue() throws BadCommandException, SDORequestError {
        if (this.mode.equals((Object)ActuatorMode.VELOCITY)) {
            this.readValue = this.readVelocity();
        } else if (this.mode.equals((Object)ActuatorMode.CURRENT)) {
            this.readValue = this.readCurrent();
        } else {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY or CURRENT mode");
        }
    }

    @Override
    public int getMotor_continuousCurrentLimit() {
        return this.motor.getContinuousCurrentLimit();
    }

    @Override
    public int getMotor_maxSpeedInCurrentMode() {
        return this.motor.getMaxSpeedInCurrentMode();
    }

    @Override
    public String getMotor_mode() {
        return this.getMode();
    }

    @Override
    public int getMotor_outputCurrentLimit() {
        return this.motor.getOutputCurrentLimit();
    }

    @Override
    public int getMotor_polePairNumber() {
        return this.motor.getPolePairNumber();
    }

    @Override
    public int getMotor_thermalTimeConstantWinding() {
        return this.motor.getThermalTimeConstantWinding();
    }

    @Override
    public int getMotor_type() {
        return this.motor.getMotorType();
    }

    @Override
    public int getPositionSensorType() {
        return this.motor.getPositionSensorType();
    }

    public void initModule() {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
        this.mode = ActuatorMode.CURRENT;
    }

    @Override
    public String initializeHardware() throws Exception {
        this.initialized = true;
        return String.valueOf(this.getName()) + ": no hardware initialization for this device to be done.";
    }

    /*
     * Exception decompiling
     */
    public boolean isEnable() throws SDORequestError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void faultReset() throws SDORequestError {
        this.writeControlWord("80");
    }

    public String enable() throws SDORequestError {
        this.lock.lock();
        this.enabling = true;
        try {
            this.shutdown();
            this.switchOnEnableOperation();
            String string = String.valueOf(this.getName()) + " ENABLE";
            return string;
        }
        finally {
            this.enabling = false;
            this.enablingCompleted.signal();
            this.lock.unlock();
        }
    }

    public String shutdown() throws SDORequestError {
        this.writeControlWord("6");
        return String.valueOf(this.getName()) + " DISABLE";
    }

    public void switchOnEnableOperation() throws SDORequestError {
        this.writeControlWord("F");
    }

    public Object saveParameters() throws SDORequestError {
        return this.writeSDO("1010", "1", "4", "65766173");
    }

    public Object restoreParameters() throws SDORequestError {
        return this.writeSDO("1011", "1", "4", "64616F6C");
    }

    public void writeControlWord(String value) throws SDORequestError {
        this.writeSDO("6040", "0", "2", value);
    }

    public String readControlWord() throws SDORequestError {
        return this.readSDO("6040", "0");
    }

    public String readStatusword() throws SDORequestError {
        return this.readSDO("6041", "0");
    }

    public void quickStop() throws SDORequestError {
        if (this.mode.equals((Object)ActuatorMode.VELOCITY)) {
            this.writeControlWord("B");
        } else if (this.mode.equals((Object)ActuatorMode.CURRENT)) {
            this.writeControlWord("2");
        }
    }

    public String unclamp() throws BadCommandException, ErrorInCommandExecutionException {
        return this.on();
    }

    @Override
    public String on() throws BadCommandException, ErrorInCommandExecutionException {
        try {
            this.enable();
            if (!this.isEnable()) {
                throw new BadCommandException("Actuator has to be enable prior ON command.");
            }
            if (this.mode.equals((Object)ActuatorMode.VELOCITY)) {
                this.setVelocity();
            } else if (this.mode.equals((Object)ActuatorMode.CURRENT)) {
                if (this.getMotor().getCurrentValue() == 0) {
                    throw new BadCommandException("A current value has to be set");
                }
                this.writeCurrent(this.getMotor().getCurrentValue());
            }
            this.on = true;
            this.sentValue = this.getMotor().getCurrentValue();
            this.updateReadValue();
            this.sendToStatus((Status)this.getStatusData());
            return String.valueOf(this.getName()) + " ON";
        }
        catch (SDORequestError ex) {
            Module.log.error((Object)(String.valueOf(this.getName()) + " Can Open ERROR in sending the command ON."));
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": Error in command ON" + ex.toString());
        }
    }

    @Override
    public String maintainUnclamped() throws BadCommandException, ErrorInCommandExecutionException {
        try {
            if (!this.isEnable()) {
                throw new BadCommandException("Actuator has to be enable prior maintainCurrent command.");
            }
            this.writeCurrent(this.motor.getCurrentValueToMaintain());
        }
        catch (SDORequestError ex) {
            Module.log.error((Object)(String.valueOf(this.getName()) + " Can Open ERROR in sending the command maintainCurrent."));
            throw new ErrorInCommandExecutionException(ex + "Error in reading ControlWord");
        }
        return String.valueOf(this.getName()) + " is maintaining its position";
    }

    public String release() throws BadCommandException, ErrorInCommandExecutionException {
        return this.off();
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        try {
            if (this.mode.equals((Object)ActuatorMode.VELOCITY)) {
                this.stopVelocity();
                this.shutdown();
            } else if (this.mode.equals((Object)ActuatorMode.CURRENT)) {
                this.stopCurrent();
                this.shutdown();
            }
            this.on = false;
            this.sentValue = 0;
            this.updateReadValue();
            this.sendToStatus((Status)this.getStatusData());
            return String.valueOf(this.getName()) + " OFF";
        }
        catch (SDORequestError ex) {
            Logger.getLogger(CanOpenClampActuatorModule.class.getName()).log(Level.SEVERE, null, ex);
            throw new ErrorInCommandExecutionException(ex + "Error in reading SDO request");
        }
    }

    public String readErrorRegister() throws SDORequestError {
        String error = this.readSDO("1001", "0");
        return String.format("%02x", Integer.parseInt(error));
    }

    public String displayErrorRegister() throws SDORequestError {
        String errorInHexa = this.readErrorRegister();
        String errorName = CanOpenErrorsTable.errorRegisterCodes.getProperty(errorInHexa);
        Module.log.debug((Object)("error register=" + errorInHexa));
        return errorName;
    }

    public String[] readErrorHistory() throws SDORequestError {
        int numberOfErrors = this.readNumberOfErrors();
        String[] errors = new String[numberOfErrors];
        int i = 0;
        while (i < numberOfErrors) {
            String subindex = Integer.toHexString(i + 1);
            errors[i] = this.readSDO("1003", subindex);
            ++i;
        }
        return errors;
    }

    public String displayErrorHistory() throws SDORequestError {
        String[] errorHistory = this.readErrorHistory();
        StringBuilder sb = new StringBuilder("Error history contains " + errorHistory.length + " errors.");
        if (errorHistory.length != 0) {
            sb.append("List of errors in history : the newest is the first, the oldest the last\n");
            int ix = 0;
            while (ix < errorHistory.length) {
                sb.append("Error code (in hexa)=");
                sb.append(errorHistory[ix]);
                sb.append("/ error name=");
                sb.append(CanOpenErrorsTable.deviceErrorCodes.getProperty(errorHistory[ix].toUpperCase()));
                sb.append("\n");
                ++ix;
            }
        }
        return sb.toString();
    }

    public int readNumberOfErrors() throws SDORequestError {
        String errorNBinHEXA = this.readSDO("1003", "0");
        return Integer.parseInt(errorNBinHEXA, 16);
    }

    public void writeMotorParameters() throws SDORequestError {
        this.shutdown();
        this.writeMotorType(this.motor.getMotorType());
        this.writeMotorData("01", "2", this.motor.getContinuousCurrentLimit());
        this.writeMotorData("04", "4", this.motor.getMaxSpeedInCurrentMode());
        this.writeMotorData("05", "2", this.motor.getThermalTimeConstantWinding());
        this.writeMotorData("02", "2", this.motor.getOutputCurrentLimit());
        this.writeMotorData("03", "1", this.motor.getPolePairNumber());
        this.writePositionSensorType(this.motor.getPositionSensorType());
    }

    public void writeMotorType(int value) throws SDORequestError {
        String typeInHexa = Integer.toHexString(value);
        this.writeSDO("6402", "0", "2", typeInHexa);
    }

    public int readMotorType() throws SDORequestError {
        String motorTypeInHexa = this.readSDO("6402", "0");
        return Integer.parseInt(motorTypeInHexa, 16);
    }

    public int readPositionSensorType() throws SDORequestError {
        String positionSensorTypeInHexa = this.readSDO("2210", "02");
        return Integer.parseInt(positionSensorTypeInHexa, 16);
    }

    public void writePositionSensorType(int value) throws SDORequestError {
        this.motor.setPositionSensorType(value);
        String valueInHexa = Integer.toHexString(value);
        this.writeSDO("2210", "2", "2", valueInHexa);
    }

    public void writeMaxSpeed(int value) throws SDORequestError {
        this.motor.setMaxSpeedInCurrentMode(value);
        this.writeMotorData("4", "4", value);
    }

    protected void writeMotorData(String subindex, String sizeInHexa, int value) throws SDORequestError {
        String valueInHexa = Integer.toHexString(value);
        this.writeSDO("6410", subindex, sizeInHexa, valueInHexa);
    }

    public int readMotorData(String subindex) throws SDORequestError {
        String valueInHexa = this.readSDO("6410", subindex);
        return Integer.parseInt(valueInHexa, 16);
    }

    public boolean checkMotorParameters() throws ClampMotorConfigurationError, SDORequestError {
        int readPolePairNumber;
        int readOutputCurrentLimit;
        int readThermalTimeConstantWinding;
        int readMaxSpeedInCurrentMode;
        int readContinuousCurrentLimit;
        int readPositionSensorType;
        boolean ok = true;
        int readMotorType = this.readMotorType();
        if (readMotorType != this.motor.getMotorType()) {
            ok = false;
        }
        if ((readPositionSensorType = this.readPositionSensorType()) != this.motor.getPositionSensorType()) {
            ok = false;
        }
        if ((readContinuousCurrentLimit = this.readMotorData("01")) != this.motor.getContinuousCurrentLimit()) {
            ok = false;
        }
        if ((readMaxSpeedInCurrentMode = this.readMotorData("04")) != this.motor.getMaxSpeedInCurrentMode()) {
            ok = false;
        }
        if ((readThermalTimeConstantWinding = this.readMotorData("05")) != this.motor.getThermalTimeConstantWinding()) {
            ok = false;
        }
        if ((readOutputCurrentLimit = this.readMotorData("02")) != this.motor.getOutputCurrentLimit()) {
            ok = false;
        }
        if ((readPolePairNumber = this.readMotorData("03")) != this.motor.getPolePairNumber()) {
            ok = false;
        }
        if (!ok) {
            throw new ClampMotorConfigurationError("ERROR in hardware configuration of the motor", this.name, readMotorType, readContinuousCurrentLimit, readMaxSpeedInCurrentMode, readThermalTimeConstantWinding, readOutputCurrentLimit, readPolePairNumber);
        }
        return ok;
    }

    public String displayMotorParameters() throws SDORequestError {
        StringBuilder sb = new StringBuilder("Read decimal values for motor parameters are :");
        int readMotorType = this.readMotorType();
        int readPositionSensorType = this.readPositionSensorType();
        int readContinuousCurrentLimit = this.readMotorData("01");
        int readMaxSpeedInCurrentMode = this.readMotorData("04");
        int readThermalTimeConstantWinding = this.readMotorData("05");
        int readOutputCurrentLimit = this.readMotorData("02");
        int readPolePairNumber = this.readMotorData("03");
        sb.append(" motor type =");
        sb.append(readMotorType);
        sb.append(" position sensor type =");
        sb.append(readPositionSensorType);
        sb.append(" continuousCurrentLimit =");
        sb.append(readContinuousCurrentLimit);
        sb.append(" maxSpeedInCurrentMode =");
        sb.append(readMaxSpeedInCurrentMode);
        sb.append(" thermalTimeConstantWinding =");
        sb.append(readThermalTimeConstantWinding);
        sb.append(" outputCurrentLimit =");
        sb.append(readOutputCurrentLimit);
        sb.append(" polePairNumber =");
        sb.append(readPolePairNumber);
        return sb.toString();
    }

    public void writeCurrent(int aValue) throws BadCommandException, SDORequestError {
        if (!this.isEnable()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not ENABLE");
        }
        if (!this.mode.equals((Object)ActuatorMode.CURRENT)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in CURRENT mode");
        }
        if (aValue > this.motor.getContinuousCurrentLimit()) {
            throw new IllegalArgumentException(String.valueOf(aValue) + " is greater than Continuous Current Limit");
        }
        this.motor.setCurrentValue(aValue);
        String currentValueInHexa = Integer.toHexString(aValue);
        this.writeSDO("2030", "0", "2", currentValueInHexa);
    }

    public int readCurrent() throws BadCommandException, SDORequestError {
        if (this.mode.equals((Object)ActuatorMode.CURRENT)) {
            String currentInHexa = this.readSDO("6078", "0");
            return Integer.parseInt(currentInHexa, 16);
        }
        throw new BadCommandException(String.valueOf(this.getName()) + "is not in CURRENT mode");
    }

    public void stopCurrent() throws BadCommandException, SDORequestError {
        if (!this.mode.equals((Object)ActuatorMode.CURRENT)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in CURRENT mode");
        }
        this.writeSDO("2030", "00", "2", "0");
    }

    public void setMaxiVelocity(int velocity) {
        if (velocity > this.getMotor().maxProfileVelocity) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + ": can't set parameters greater than maxi value");
        }
        this.motor.maxProfileVelocity = velocity;
    }

    public void setMaxiAcceleration(int acceleration) {
        if (acceleration > this.getMotor().maxAcceleration) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + ": can't set parameters greater than maxi value");
        }
        this.motor.maxAcceleration = acceleration;
    }

    public void setVelocity() throws BadCommandException {
        if (!this.mode.equals((Object)ActuatorMode.VELOCITY)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY mode");
        }
    }

    public int readVelocity() throws BadCommandException {
        if (this.mode.equals((Object)ActuatorMode.VELOCITY)) {
            return 0;
        }
        throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY mode");
    }

    public void stopVelocity() throws BadCommandException {
        if (!this.mode.equals((Object)ActuatorMode.VELOCITY)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY mode");
        }
    }

    public String writeSDO(String index, String subindex, String length, String newValue) throws SDORequestError {
        return this.tcpProxy.writeSDO(this.nodeID, index, subindex, length, newValue);
    }

    public String readSDO(String index, String subindex) throws SDORequestError {
        return this.tcpProxy.readSDO(this.nodeID, index, subindex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/");
        sb.append(this.serialNB);
        sb.append("/NodeID_in_hexa=");
        sb.append(this.nodeID);
        int x = Integer.parseInt(this.nodeID, 16);
        sb.append("/NodeID_in_decimal=");
        sb.append(x);
        sb.append("/");
        if (this.tcpProxy == null) {
            return sb.toString();
        }
        if (this.isNodeIdBootedAndOK()) {
            sb.append("is booted/");
        } else {
            sb.append("ERROR/");
        }
        return sb.toString();
    }

    public static enum ActuatorMode {
        VELOCITY,
        CURRENT;

    }
}

