/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.ClampActuatorModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareError;
import org.lsst.ccs.subsystems.fcs.errors.SensorValueOutOfRangeException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public abstract class FilterClampModule
extends Module {
    private ClampActuatorModule actuator;
    private Sensor14bits filterPresenceSensor;
    private Sensor14bits lockSensor;
    private Thermometer thermometer;
    protected FcsEnumerations.FilterClampState clampState;
    protected FcsEnumerations.FilterPresenceStatus filterPresenceStatus;
    private FcsEnumerations.LockStatus lockStatus;
    protected double temperature;
    private int lockSensorValueA;
    private int lockSensorValueB;
    private int lockSensorValueC;
    private int lockSensorOffset;
    private static int lockSensorMinValue = Sensor14bits.minValue;
    private static int lockSensorMaxValue = Sensor14bits.maxValue;
    private static int filterPositionMinValue = Sensor14bits.minValue;
    private static int filterPositionMaxValue = Sensor14bits.maxValue;
    private int filterPositionValueA;
    private int filterPositionValueB;
    private int filterPositionValueC;
    private int filterPositionOffset;
    public String publishedByClampOutputName = "publishedByClamp";
    private boolean initialized = false;
    final Lock lock = new ReentrantLock();
    final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;

    public ClampActuatorModule getActuator() {
        return this.actuator;
    }

    public void setActuator(ClampActuatorModule actuator) {
        this.actuator = actuator;
    }

    public void setFilterPositionValueA(int valueA) {
        this.filterPositionValueA = valueA;
    }

    public void setFilterPositionValueB(int valueB) {
        this.filterPositionValueB = valueB;
    }

    public void setFilterPositionValueC(int valueC) {
        this.filterPositionValueC = valueC;
    }

    public int getLockSensorValueA() {
        return this.lockSensorValueA;
    }

    public void setLockSensorValueA(int aValue) {
        this.lockSensorValueA = aValue;
    }

    public int getLockSensorValueB() {
        return this.lockSensorValueB;
    }

    public void setLockSensorValueB(int aValue) {
        this.lockSensorValueB = aValue;
    }

    public int getLockSensorValueC() {
        return this.lockSensorValueC;
    }

    public void setLockSensorValueC(int lockSensorValueC) {
        this.lockSensorValueC = lockSensorValueC;
    }

    public int getFilterPositionMaxValue() {
        return filterPositionMaxValue;
    }

    public int getFilterPositionMinValue() {
        return filterPositionMinValue;
    }

    public int getLockSensorMaxValue() {
        return lockSensorMaxValue;
    }

    public int getLockSensorMinValue() {
        return lockSensorMinValue;
    }

    public int getFilterPositionValueA() {
        return this.filterPositionValueA;
    }

    public int getFilterPositionValueB() {
        return this.filterPositionValueB;
    }

    public int getFilterPositionValueC() {
        return this.filterPositionValueC;
    }

    public int getLockSensorOffset() {
        return this.lockSensorOffset;
    }

    public void setLockSensorOffset(int lockSensorOffset) {
        this.lockSensorOffset = lockSensorOffset;
    }

    public int getFilterPositionOffset() {
        return this.filterPositionOffset;
    }

    public void setFilterPositionOffset(int filterPositionOffset) {
        this.filterPositionOffset = filterPositionOffset;
    }

    public Sensor14bits getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public void setFilterPresenceSensor(Sensor14bits filterPresenceSensor) {
        this.filterPresenceSensor = filterPresenceSensor;
    }

    public Sensor14bits getLockSensor() {
        return this.lockSensor;
    }

    public Thermometer getThermometer() {
        return this.thermometer;
    }

    public void setThermometer(Thermometer thermometer) {
        this.thermometer = thermometer;
    }

    public void setLockSensor(Sensor14bits lockSensor) {
        this.lockSensor = lockSensor;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(FcsEnumerations.LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void initModule() {
        this.clampState = FcsEnumerations.FilterClampState.UNDEFINED;
        this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE;
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        this.temperature = 0.0;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.FilterClampState getClampState() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    public synchronized boolean isFilterEngaged() {
        return this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE);
    }

    public void updateFilterPresenceStatus() throws HardwareError {
        this.filterPresenceSensor.updateValue();
        int newFilterPresenceSensorValue = this.filterPresenceSensor.getValue();
        int mechaValue = newFilterPresenceSensorValue - this.filterPositionOffset;
        if (mechaValue < this.filterPositionValueA) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            Module.log.error((Object)(String.valueOf(this.getName()) + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue));
            throw new SensorValueOutOfRangeException("FILTER POSITION SENSOR", this.filterPresenceSensor.getName(), filterPositionMinValue, filterPositionMaxValue, mechaValue);
        }
        this.filterPresenceStatus = mechaValue < this.filterPositionValueB ? FcsEnumerations.FilterPresenceStatus.LOCKABLE : (mechaValue < this.filterPositionValueC ? FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE : FcsEnumerations.FilterPresenceStatus.NOFILTER);
    }

    private void updateFilterPresenceStatus(CanOpenProxy.PDOStorage pdoStorage) throws HardwareError {
        int newFilterPresenceSensorValue = this.filterPresenceSensor.updateValue(pdoStorage);
        int mechaValue = newFilterPresenceSensorValue - this.filterPositionOffset;
        if (mechaValue < this.filterPositionValueA) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            Module.log.error((Object)(String.valueOf(this.getName()) + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue));
            throw new SensorValueOutOfRangeException("FILTER POSITION SENSOR", this.filterPresenceSensor.getName(), filterPositionMinValue, filterPositionMaxValue, mechaValue);
        }
        this.filterPresenceStatus = mechaValue < this.filterPositionValueB ? FcsEnumerations.FilterPresenceStatus.LOCKABLE : (mechaValue < this.filterPositionValueC ? FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE : FcsEnumerations.FilterPresenceStatus.NOFILTER);
    }

    public void updateLockStatus() throws HardwareError {
        this.lockSensor.updateValue();
        int newLockSensorValue = this.lockSensor.getValue();
        int mechaValue = newLockSensorValue - this.lockSensorOffset;
        if (mechaValue < this.lockSensorValueA) {
            this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
        } else if (mechaValue <= this.lockSensorValueB) {
            this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        } else if (mechaValue <= this.lockSensorValueC) {
            this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
        } else {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            Module.log.error((Object)(String.valueOf(this.getName()) + " ERROR new read value FOR LOCK SENSOR  = " + newLockSensorValue));
            throw new SensorValueOutOfRangeException("ERROR in reading LOCK SENSOR", this.lockSensor.getName(), lockSensorMinValue, lockSensorMaxValue, mechaValue);
        }
    }

    private void updateLockStatus(CanOpenProxy.PDOStorage pdoStorage) throws HardwareError {
        int newLockSensorValue = this.lockSensor.updateValue(pdoStorage);
        int mechaValue = newLockSensorValue - this.lockSensorOffset;
        if (mechaValue < this.lockSensorValueA) {
            this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
        } else if (mechaValue <= this.lockSensorValueB) {
            this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        } else if (mechaValue <= this.lockSensorValueC) {
            this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
        } else {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            Module.log.error((Object)(String.valueOf(this.getName()) + " ERROR new read value FOR LOCK SENSOR  = " + newLockSensorValue));
            throw new SensorValueOutOfRangeException("ERROR in reading LOCK SENSOR", this.lockSensor.getName(), lockSensorMinValue, lockSensorMaxValue, mechaValue);
        }
    }

    public void updateStateWithSensors() throws HardwareError {
        this.lock.lock();
        this.updatingState = true;
        try {
            this.updateFilterPresenceStatus();
            this.updateLockStatus();
            this.clampState = this.computeClampState();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        StatusDataPublishedByClamp status = this.getStatusData();
        this.sendToStatus((Status)status);
        this.publishTrendingData(status);
    }

    void updateStateWithSensors(CanOpenProxy.PDOStorage pdoStorage) throws HardwareError {
        this.lock.lock();
        this.updatingState = true;
        try {
            this.updateFilterPresenceStatus(pdoStorage);
            this.updateLockStatus(pdoStorage);
            this.clampState = this.computeClampState();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        StatusDataPublishedByClamp status = this.getStatusData();
        this.sendToStatus((Status)status);
        this.publishTrendingData(status);
    }

    public void publishTrendingData(StatusDataPublishedByClamp status) {
        long timeStamp = System.currentTimeMillis();
        ArrayList<ValueNotification> trendingValues = new ArrayList<ValueNotification>();
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/clampState", (Object)status.getClampState(), timeStamp));
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/filterPositionInClamp", (Object)status.getFilterPositionInClamp(), timeStamp));
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/filterPositionSensorValue", (Object)status.getFilterPositionSensorValue(), timeStamp));
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/lockStatus", (Object)this.lockStatus, timeStamp));
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/lockSensorValue", (Object)status.getLockSensorValue(), timeStamp));
        this.publishData(trendingValues);
    }

    public FcsEnumerations.FilterClampState computeClampState() {
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.ERROR) || this.lockStatus.equals((Object)FcsEnumerations.LockStatus.ERROR)) {
            return FcsEnumerations.FilterClampState.ERROR;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE)) {
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                return FcsEnumerations.FilterClampState.CLAMPEDONFILTER;
            }
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED)) {
                return FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
            }
            return FcsEnumerations.FilterClampState.UNDEFINED;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.NOFILTER)) {
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                return FcsEnumerations.FilterClampState.READYTOCLAMP;
            }
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED)) {
                return FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY;
            }
            return FcsEnumerations.FilterClampState.ERROR;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE)) {
            return FcsEnumerations.FilterClampState.UNDEFINED;
        }
        return FcsEnumerations.FilterClampState.UNDEFINED;
    }

    public StatusDataPublishedByClamp getStatusData() {
        StatusDataPublishedByClamp status = FcsUtils.createStatusDataPublishedByClamp(this);
        return status;
    }

    public String release() throws BadCommandException, ErrorInCommandExecutionException, HardwareError {
        Module.log.debug((Object)("Checking conditions for release clamp " + this.getName() + " on socket at standby position."));
        this.updateStateWithSensors();
        while (this.updatingState) {
            try {
                this.stateUpdated.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FilterClampModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!this.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY)) {
            throw new BadCommandException("Can't release a clamp if isn't unclamped and empty.");
        }
        Module.log.debug((Object)("Releasing clamp " + this.getName() + " on socket at standby position."));
        this.actuator.off();
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FilterClampModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.updateStateWithSensors();
        while (this.updatingState) {
            try {
                this.stateUpdated.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FilterClampModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.clampState.equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP)) {
            return String.valueOf(this.getName()) + " is released";
        }
        throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": Could not release clamp.");
    }

    public String unlock() throws BadCommandException, ErrorInCommandExecutionException, HardwareError {
        Module.log.debug((Object)(String.valueOf(this.getName()) + ": " + "UNLOCK State1 = " + this.clampState.toString()));
        this.updateStateWithSensors();
        if (!this.getClampState().equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER)) {
            throw new BadCommandException("Can't unlock a clamp if isn't clamped on filter.");
        }
        this.actuator.on();
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FilterClampModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.updateStateWithSensors();
        while (this.updatingState) {
            try {
                this.stateUpdated.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FilterClampModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Module.log.debug((Object)(String.valueOf(this.getName()) + ":UNLOCK State2 = " + this.clampState.toString()));
        if (this.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
            return String.valueOf(this.getName()) + " is unlocked";
        }
        throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": Could not unlock clamp.");
    }

    public double updateTemperature() throws HardwareError {
        double temp;
        this.temperature = temp = this.thermometer.readTemperature();
        return temp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/filterPresenceSensor=");
        sb.append(this.filterPresenceSensor.getName());
        sb.append("#valueA=");
        sb.append(this.filterPositionValueA);
        sb.append("#valueB=");
        sb.append(this.filterPositionValueB);
        sb.append("#valueC=");
        sb.append(this.filterPositionValueC);
        sb.append("/lockSensor=");
        sb.append(this.lockSensor.getName());
        sb.append("#valueA=");
        sb.append(this.lockSensorValueA);
        sb.append("#valueB=");
        sb.append(this.lockSensorValueB);
        sb.append("#valueC=");
        sb.append(this.lockSensorValueC);
        return sb.toString();
    }
}

