/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.common.FilterLocation;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareError;

public class CarouselSocket {
    private FilterClampModule clampXminus;
    private FilterClampModule clampXplus;
    private double position;
    private double standbyPosition;
    private Filter filter;
    volatile boolean updatingClamps = false;
    volatile boolean releasingClamps = false;
    volatile boolean unlockingClamps = false;
    private volatile FcsEnumerations.FilterClampState clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
    final Lock lock = new ReentrantLock();
    final Condition stateUpdated = this.lock.newCondition();
    final Condition releaseCompleted = this.lock.newCondition();
    final Condition unlockCompleted = this.lock.newCondition();

    public CarouselSocket() {
    }

    public CarouselSocket(double position) {
        this.position = position;
        this.standbyPosition = position == 0.0 ? 0.0 : 360.0 - position;
    }

    public FilterClampModule getClampXminus() {
        return this.clampXminus;
    }

    public void setClampXminus(FilterClampModule clampXminus) {
        this.clampXminus = clampXminus;
    }

    public FilterClampModule getClampXplus() {
        return this.clampXplus;
    }

    public void setClampXplus(FilterClampModule clampXplus) {
        this.clampXplus = clampXplus;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double position) {
        this.position = position;
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected void setFilter(Filter filter) {
        this.filter = filter;
    }

    public double getStandbyPosition() {
        return this.standbyPosition;
    }

    public void setStandbyPosition(double standbyPosition) {
        this.standbyPosition = standbyPosition;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.FilterClampState getClampsState() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateClampsStateWithSensors() throws HardwareError {
        block4: {
            this.lock.lock();
            this.updatingClamps = true;
            try {
                this.clampXminus.updateStateWithSensors();
                this.clampXplus.updateStateWithSensors();
                if (this.clampXminus.getClampState().equals((Object)this.clampXplus.getClampState())) {
                    this.clampsState = this.clampXminus.getClampState();
                    System.out.println("XXXXXXXXSocket at standby : clamps are updated");
                    break block4;
                }
                throw new HardwareError("Error in filter presence detection at standby position : the clamps don't agree.");
            }
            finally {
                this.updatingClamps = false;
                this.stateUpdated.signal();
                this.lock.unlock();
            }
        }
    }

    public void updateClampsStateWithSensors(CanOpenProxy.PDOStorage pdoStorage) throws HardwareError {
        block4: {
            this.lock.lock();
            this.updatingClamps = true;
            try {
                this.clampXminus.updateStateWithSensors(pdoStorage);
                this.clampXplus.updateStateWithSensors(pdoStorage);
                if (this.clampXminus.getClampState().equals((Object)this.clampXplus.getClampState())) {
                    this.clampsState = this.clampXminus.getClampState();
                    System.out.println("XXXXXXXXSocket at standby : clamps are updated");
                    break block4;
                }
                throw new HardwareError("Error in filter presence detection at standby position : the clamps don't agree.");
            }
            finally {
                this.updatingClamps = false;
                this.stateUpdated.signal();
                this.lock.unlock();
            }
        }
    }

    public boolean isEmpty() throws HardwareError {
        return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP) || this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY);
    }

    public boolean isClampedOnFilter() {
        return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER);
    }

    public boolean isUnclampedOnFilter() {
        return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER);
    }

    public boolean isUnclampedEmpty() {
        return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY);
    }

    public boolean isReadyToClamp() {
        return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP);
    }

    public String releaseClamps() throws BadCommandException, ErrorInCommandExecutionException, HardwareError {
        this.lock.lock();
        this.releasingClamps = true;
        try {
            this.clampXminus.release();
            this.clampXplus.release();
            if (this.clampXminus.getClampState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP) & this.clampXplus.getClampState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP)) {
                this.clampsState = FcsEnumerations.FilterClampState.READYTOCLAMP;
                System.out.println("XXXXXXXXSocket at standby : clamps are released");
            } else {
                if (!this.clampXminus.getClampState().equals((Object)this.clampXplus.getClampState())) {
                    throw new HardwareError("Error in filter presence detection at standby position : the clamps don't agree.");
                }
                if (!this.clampXminus.getClampState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP)) {
                    throw new ErrorInCommandExecutionException("Could not release clampX-");
                }
                if (!this.clampXplus.getClampState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP)) {
                    throw new ErrorInCommandExecutionException("Could not release clampX+");
                }
            }
        }
        finally {
            this.releasingClamps = false;
            this.releaseCompleted.signal();
            this.lock.unlock();
        }
        if (this.clampsState.equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP)) {
            return "Clamps are released at standby.";
        }
        return "Unable to release clamps at standby.";
    }

    public String unlockClamps() throws BadCommandException, ErrorInCommandExecutionException, HardwareError {
        this.lock.lock();
        this.unlockingClamps = true;
        try {
            this.clampXminus.unlock();
            this.clampXplus.unlock();
            if (this.clampXminus.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER) & this.clampXplus.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
                this.clampsState = FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
            } else {
                if (!this.clampXminus.getClampState().equals((Object)this.clampXplus.getClampState())) {
                    throw new HardwareError("Error in filter presence detection at standby position : the clamps don't agree.");
                }
                if (!this.clampXminus.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
                    throw new ErrorInCommandExecutionException("Could not unlock clampX-");
                }
                if (!this.clampXplus.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
                    throw new ErrorInCommandExecutionException("Could not unlock clampX+");
                }
            }
        }
        finally {
            this.unlockingClamps = false;
            this.unlockCompleted.signal();
            this.lock.unlock();
        }
        if (this.clampsState.equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
            return "Clamps are locked at standby.";
        }
        return "Unable to unlock clamps at standby.";
    }

    public void removeFilter() throws BadCommandException {
        if (this.filter == null) {
            throw new BadCommandException("Carousel socket : there is no filter to remove at standby position");
        }
        this.filter = null;
    }

    public synchronized void putFilterOnSocket(Filter filter) {
        this.setFilter(filter);
        filter.setFilterLocation(FilterLocation.ONCAROUSEL);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("Filter in socket : ");
        if (this.getFilter() == null) {
            sb.append(" NO FILTER").append("\n");
        } else {
            sb.append(this.getFilter().getName()).append("\n");
        }
        return sb.toString();
    }
}

