/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.HygrometrySensor;
import org.lsst.ccs.subsystems.fcs.common.PressureSensor;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * Main Module for the test bench in LPC in Clermont-Ferrand.
 * @author virieux
 */
public class Scale1ProtoTestBenchMainModule extends MainModule {
    
    
    private final HygrometrySensor hygrometrySensor;
    private final PressureSensor pressureSensor;
    private final Thermometer thermometer;
    private final Scale1ProtoPivotingFrame pivotingFrame;
    private final LPCInclinometerModule inclinometer;
    
    
    private final CanOpenLED led;
    private final CanOpenLED fakeLed;
    private final Thermometer fakeSensor;
    
    public double temperature;
    public double pressure;
    public double hygrometry;



    public Scale1ProtoTestBenchMainModule(String aName, int aTickMillis, 
            BridgeToHardware bridge, 
            HygrometrySensor hygrometrySensor, 
            PressureSensor pressureSensor, 
            Thermometer thermometer, 
            CanOpenLED led, 
            CanOpenLED fakeLed, 
            Thermometer fakeSensor,
            Scale1ProtoPivotingFrame pivotingFrame,
            LPCInclinometerModule inclinometer) {
        super(aName, aTickMillis, bridge);
        this.hygrometrySensor = hygrometrySensor;
        this.pressureSensor = pressureSensor;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
        this.pivotingFrame = pivotingFrame;
        this.inclinometer = inclinometer;
    }
    
    public double readHygrometry() throws FcsHardwareException {
        this.hygrometry = this.hygrometrySensor.readHygrometry();
        return this.hygrometry;
    }
    
    public double readPressure() throws FcsHardwareException {
        this.pressure = this.pressureSensor.readPressure();
        return this.pressure;
    }
    
    public double readTemperature() throws FcsHardwareException {
        this.temperature = this.thermometer.readTemperature();
        return this.temperature;
    }
    
    public String turnOnLED() throws SDORequestException, HardwareNotDetectedException {
        return led.turnON();
    }
    

    
    public String turnOffLED() throws SDORequestException, HardwareNotDetectedException {
        return led.turnOFF();       
    }
    
    public String turnOnFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return fakeLed.turnON();       
    }
    
    public String turnOffFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return fakeLed.turnOFF();       
    }
    
    public double readFakeSensor() throws FcsHardwareException, BadCommandException {
//        CanOpenProxy.PDOStorage pdoStore = this.bridge.readPDOs();
//        return this.fakeSensor.readTemperatureWithPDO(pdoStore);
        return this.fakeSensor.readTemperature();
    }
    
    public void rotateCamera(long angle) {
        this.pivotingFrame.rotateCamera(angle);
    }
    
    public void rotateX(long angle) {
        this.pivotingFrame.rotateX(angle);
    }
    
    @Override
    public void tick() {
        try {
            readTemperature();
            readPressure();
            readHygrometry();            
            this.publish("temperature", this.temperature);
            this.publish("hygrometry", this.hygrometry);
            this.publish("pressure", this.pressure);
            
        } catch (FcsHardwareException ex) {
            fcslog.debug(getName() + "couldn't read sensors");
        }
    }
    
    
    
}
