/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDigitaxVariator;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This is a model for the mobile part of the scale1 prototype test bench.
 * @author Virieux, Chassagny
 */
public class Scale1ProtoPivotingFrame extends MobileItemModule {
    
    private final CanOpenDigitaxVariator variatorX;
    private final CanOpenDigitaxVariator variatorZ;

    public Scale1ProtoPivotingFrame(String moduleName, int aTickMillis,
        CanOpenDigitaxVariator variatorX,
        CanOpenDigitaxVariator variatorZ) {
        super(moduleName, aTickMillis);
        this.variatorX = variatorX;
        this.variatorZ = variatorZ;
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, description="Returns true if hardware is connected and ready.")
    @Override
    public boolean isHardwareReady() {
        return ((MainModule) this.getModule("main")).isHardwareReady();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void stopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
    public String goToHome() {
        //TODO
        return name + " is at Home Position.";
    }
    
    /**
     * to rotate around X axis
     * @param angle
     * @return 
     */
    public String rotateX(long angle) {
        //TODO
        //variatorX.
        return name + " has rotated at requested angle: " + angle;        
    }
    
    /**
     * to rotate around Z axis
     * @param angle
     * @return 
     */
    public String rotateCamera(long angle) {
        //TODO
        return name + " has rotated";
    }
    
}
