/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import java.beans.ConstructorProperties;
import org.lsst.ccs.subsystems.fcs.InclinometerModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.OnlineClampModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS70;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenPlutoGateway;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;


/**
 * This subsystem is to read some sensors in CPPM through the pluto gateway.
 * @author virieux
 */
public class CPPMTestBenchMainModule extends MainModule {
    

    private final InclinometerModule inclinometer;
    private final OnlineClampModule onlineClamp;

    
    CanOpenPlutoGateway plutoGateway;
    
    CanOpenEPOS70 linearRailMasterController;
    CanOpenEPOS70 linearRailSlaveController;


        @ConstructorProperties({"name", "tickmillis", 
        "bridge", 
        "inclinometer",
        "onlineClamp"})
    public CPPMTestBenchMainModule(String aName, int aTickMillis, 
            BridgeToHardware aBridge,
            InclinometerModule inclinometer,
            OnlineClampModule onlineClamp) {
        super(aName, aTickMillis, aBridge);
        this.inclinometer = inclinometer;
        this.onlineClamp = onlineClamp;
    }
    


    @Override
    public void initModule() {
        super.initModule();
        plutoGateway = (CanOpenPlutoGateway) this.getModule("plutoGateway");
        linearRailMasterController = (CanOpenEPOS70) this.getModule("linearRailMasterController");
        linearRailSlaveController = (CanOpenEPOS70) this.getModule("linearRailSlaveController");
    }
      
    
    /**
     * To enable the EPOS controller.
     * POUR PATRICK :
     * This can be done too from the console with the command:
     * console> invoke testbenchCPPM/linearRailMasterController enable
     * This is true for all the methods in CAnOpenEPOS.
     * @return
     * @throws SDORequestException 
     */
    public String enableEPOS() throws SDORequestException {
        this.linearRailMasterController.enable();
        return (this.linearRailMasterController.getName() + " is enable");
    }
    
}
