/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * This class is to simulate an EPOS Controller which controls the loader hooks.
 * @author virieux
 */
public class SimuEPOSControllerModule extends Module implements EPOSController {
//public class SimuEPOSControllerModule extends CanOpenEPOS {
    
    protected static final Logger fcslog = FcsUtils.log;
    
    SimuPlutoGateway plutoGateway;
    LoaderClampModule clamp;
    
    public boolean on;
    CanOpenEPOS.EposMode mode;
    int absolutePosition;
    int targetPosition;
    int position;
    int current;

    public SimuEPOSControllerModule(String string, int i) {
        super(string, i);
    }

    
    
    
    
    @Override
    public void initModule() {
        plutoGateway = (SimuPlutoGateway)this.getModule("plutoGateway");
        clamp = (LoaderClampModule)this.getModule("clamp");
    }
    
     /**
     * Changes the mode to the new mode given as a String argument.
     * @param modeInString
     * @return
     * @throws SDORequestException 
     */
    public String changeMode(String modeInString) throws SDORequestException {
        CanOpenEPOS.EposMode newMode = CanOpenEPOS.EposMode.valueOf(modeInString.trim().toUpperCase());
        return changeMode(newMode);
    }

    @Override
    public String changeMode(CanOpenEPOS.EposMode newMode) throws SDORequestException {
        this.mode = newMode;
        return getName() + " mode changed to=" + newMode.toString();
    }

    @Override
    public boolean checkMotorParameters() throws EPOSConfigurationException {
        //throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
        return true;
    }

    @Override
    public void defineAbsolutePosition(int position) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        //this.absolutePosition = position;
        this.position = position;
    }

    @Override
    public void writeParameters(CanOpenEPOS.EposMode mode) throws SDORequestException, ErrorInCommandExecutionException { 
    }

    @Override
    public void writeTargetPosition(int position) throws BadCommandException, SDORequestException {
        //this.targetPosition = position;
        this.position = position;
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) throws SDORequestException {
    }

    @Override
    public void writeCurrent(int aValue) throws BadCommandException, SDORequestException {
        this.current = aValue;
    }

    @Override
    public String on() throws SDORequestException, BadCommandException, ErrorInCommandExecutionException {
        try {
            Thread.sleep(2 * tickMillis);
        } catch (InterruptedException ex) {
            fcslog.warning(getName() + ":Error in command ON " + ex.toString());
            return getName() + ":command OFF interrupted";
        }
        
        switch(mode) {
            case PROFILE_POSITION:
                if (position == clamp.getTargetPositionToOpen()) {
                    this.plutoGateway.simulateLoaderClampIsUnLocked();
                } else if ((position == clamp.getTargetPositionToClose())) {
                    this.plutoGateway.simulateLoaderClampIsLocked();
                } else if ((position == clamp.getTargetPositionToClamp())) {
                    this.plutoGateway.simulateLoaderClampIsLocked();
                } else {
                    fcslog.debug(getName() + " ERROR in command ON: the position has a bad value.");
                }
                break;
                
            case CURRENT:
                if (current == clamp.getCurrentToGoHome()) {
                    this.plutoGateway.simulateLoaderClampIsUnLocked();
                } else if (current == clamp.getCurrentToClose()) {
                    this.plutoGateway.simulateLoaderClampIsLocked();
                }
                break;
                
            default:
                //this should not happen.
                fcslog.debug(name + " ERROR in command ON: mode has to be CURRENT or PROFILE_POSITION.");
                break;
                
        }
               
        return name + " is ON";
    }

    @Override
    public String off() throws SDORequestException, BadCommandException {
//        try {
//            Thread.sleep(2 * tickMillis);
//        } catch (InterruptedException ex) {
//            fcslog.warning(getName() + ":Error in command OFF " + ex.toString());
//            return getName() + ":command OFF interrupted";
//        }
//        this.plutoGateway.simulateLoaderClampIsUnLocked();
        return name + " is OFF";
    }

    @Override
    public boolean isOn() {
        return on;
    }

    @Override
    public boolean isOff() {
        return !on;
    }
    
        @Override
    public void setOn(boolean on) {
        this.on = on;
    }


    @Override
    public int getReadCurrentValue() {
        return this.current;
    }

    @Override
    public int getSentCurrentValue() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getSentCurrentMinValue() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getSentCurrentMaxValue() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean isTargetPositionReached(int targetPosition) {
        return (this.position == targetPosition);
    }


    @Override
    public int readPosition() throws SDORequestException {
        return this.position;
    }

    @Override
    public String enable() throws SDORequestException {
        return name + "IS ENABLED";
    }

    @Override
    public int readCurrent() throws BadCommandException, SDORequestException {
        return this.current;
    }

    @Override
    public String readMode() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }


    
    
}
