/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

/**
 *
 * @author virieux
 */
public class CanOpenPlutoGateway extends PlutoGatewayModule implements PieceOfHardware {
    

    
    
    
    //TODO : this class should have a field :
    //CanOpenDevice deviceDelegate and delegate the CanOpenDevice methods to this device Delegate

    CanOpenProxy tcpProxy;
    
    String serialNB;
    String nodeID;
    boolean initialized;

    //TODO mettre un @ConstructorProperty
    public CanOpenPlutoGateway(String string, int i, 
            String nodeID, String serialNB) {
        super(string, i);
        this.nodeID = nodeID;
        this.serialNB = serialNB;       
        this.initialized = false;
    }
    
    


    
    @Override
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public boolean isNodeIdBootedAndOK() {
        return tcpProxy.isNodeIdBootedAndOK(this);
    }

    @Override
    public boolean isInitalized() {
        return this.initialized;
    }
    
    
    @Override
    public void initModule() {
        super.initModule();
        tcpProxy = (CanOpenProxy) this.getModule("tcpProxy");
    }
    
    @Override
    public String initializeHardware() throws SDORequestException, ErrorInCommandExecutionException {
        //return configure();  
        return getName() + "nothing to do";
    }
    
    public String configure() throws SDORequestException, ErrorInCommandExecutionException {
        String ack = this.tcpProxy.writeSDO(nodeID,"2002", "01", "01", "04");
        String goodAck = "OK";
        if (!ack.equals(goodAck)) throw new ErrorInCommandExecutionException(getName() + " :bad returned ack for wsdo, index 2002");
        return (getName() + " is configured.");
    }
    
    public String writeTransmissionType(String transmissionType) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        if (transmissionType == null) throw new BadCommandException(getName() + ": Can't write transmission type to device because transmaission type is null.");
        String ack = this.tcpProxy.writeSDO(this.nodeID, "2005", "1", "1", transmissionType);
        String goodAck = "OK";
        if (!ack.equals(goodAck)) throw new ErrorInCommandExecutionException(getName() + " :bad returned ack for wsdo, index 1801");
                
        return String.format("Transmission type of device %s is now %s", this.name, transmissionType);   
    }
    
     /* 
     * @return values in hexa read on the device
     */   
    @Override
    public String[] readNewHexaValues() throws FcsHardwareException {
        if (!isNodeIdBootedAndOK()) throw new FcsHardwareException(name + " is not booted - can't read new values.");
        try {
            hexaValues[0] = tcpProxy.readSDO(this.nodeID, "6000", "03");
            fcslog.finest(String.format("%s : first byte read in hexaValue= %s",name,hexaValues[0]));
            hexaValues[1] = tcpProxy.readSDO(this.nodeID, "6000", "04");
            fcslog.finest(String.format("%s : second byte read in hexaValue= %s",name,hexaValues[1]));
        
        } catch (ShortResponseToSDORequestException ex) {
            fcslog.warning(name + "=> ERROR IN READING SENSOR:" + ex.getMessage());
            
        } catch (SDORequestException ex) {
            String message = name + "=> ERROR IN READING SENSOR:";
            fcslog.error(message + ex.toString());
            //this.getSubsystem().raiseAlarm(ex.toString());
                    
        }
        return hexaValues;
    }
    
    @Override
    public int readNewAnalogValue() throws FcsHardwareException {
        //read the registers
        String hexaL = tcpProxy.readSDO(this.nodeID, "6001", "01");
        fcslog.finest(name + ": new analog value in hexa=" + hexaL);
        String hexaM = tcpProxy.readSDO(this.nodeID, "6001", "02");
        String valueInHexa = hexaM + hexaL;
        fcslog.finest(name + ": new analog value in hexa=" + valueInHexa);
        int newAnalogValue = Integer.parseInt(valueInHexa, 16);
        fcslog.finest(name + ": new analog value =" + newAnalogValue);
        return newAnalogValue;
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(getName());       
        sb.append("/SerialNumber=");
        sb.append(this.serialNB);
        sb.append("/NodeID_in_hexa=");
        sb.append(this.nodeID);
        int x = Integer.parseInt(this.nodeID,16);
        sb.append("/NodeID_in_decimal=");sb.append(x);sb.append("/");
        // because the configuration system can call toString before the object is completely built
        // for tracing purpose.
        if (tcpProxy == null ) return sb.toString();
        if (isNodeIdBootedAndOK())  {
            sb.append("BOOTED/");
            
        } else {
            sb.append("NOT YET BOOTED/");
        }       
        return sb.toString();
    }


  
    
}
