/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
/**
 * This class deviceErrorFile a utility class to load the property files we need to monitor
 * a Can Open device : 
 * - device error codes
 * - error register codes
 * - communication errors
 * @author virieux
 */
public class CanOpenErrorsTable {
    
    protected static final Logger fcslog = FcsUtils.log;
    /*********************************/
    /*Methods to handle errors       */
    /*********************************/
    
    /*Device Error Code (index 1003)*/
    static Properties deviceErrorCodes = new Properties();
    //the file maxonMotorDeviceErrors.properties deviceErrorFile in the directory : org-lsst-ccs-subsystem-fcs/trunk/src/main/resources
    static final String DEVICE_ERROR_CODES_FILENAME = "/maxonMotorDeviceErrors.properties";
    static InputStream deviceErrorFile = CanOpenErrorsTable.class.getResourceAsStream(DEVICE_ERROR_CODES_FILENAME);
    
    /*Error Register Code (index 1001)*/
    static Properties errorRegisterCodes = new Properties();
    //the file errorRegister.properties deviceErrorFile in the directory : org-lsst-ccs-subsystem-fcs/trunk/src/main/resources
    static final String ERROR_REGISTER_CODES_FILENAME = "/errorRegister.properties";
    static InputStream errorRegisterFile = CanOpenErrorsTable.class.getResourceAsStream(ERROR_REGISTER_CODES_FILENAME);
    
        /*Device Error Code (index 1003)*/
    static Properties commErrorCodes = new Properties();
    //the file maxonMotorDeviceErrors.properties deviceErrorFile in the directory : org-lsst-ccs-subsystem-fcs/trunk/src/main/resources
    static final String COMM_ERROR_CODES_FILENAME = "/commErrors.properties";
    static InputStream commErrorFile =  CanOpenErrorsTable.class.getResourceAsStream(COMM_ERROR_CODES_FILENAME);

    
    public static void loadDeviceErrorTable() throws DeploymentException {
        try {
            fcslog.debug("DEVICE ERROR TABLE= " + deviceErrorFile.toString());
            deviceErrorCodes.load(deviceErrorFile);
            int size = deviceErrorCodes.size();
            fcslog.debug("Size of the maxon device error codes table = " + size);
        } catch (IOException ex) {
            //Logger.getLogger(CanOpenClampActuatorModule.class.getName()).loggerger(Level.SEVERE, null, ex);
            throw new DeploymentException("Error in reading file: " + DEVICE_ERROR_CODES_FILENAME + ex.getMessage());
        }

    }
    
    /**
     * Return the name of an error code given as a parameter
     * in reading in the error codes table.
     * @param code error in hexa
     * @return the name
     */
    public static String getDeviceErrorNameByCode(String aCode) {
        
        fcslog.debug((String) deviceErrorCodes.getProperty(aCode.toUpperCase()));
        
        return (String) deviceErrorCodes.getProperty(aCode.toUpperCase());
    }
    

    
    public static void loadErrorRegisterTable() throws DeploymentException {
        try {
            fcslog.debug("ERROR REGISTER TABLE=" + errorRegisterFile.toString());
            errorRegisterCodes.load(errorRegisterFile);
            int size = errorRegisterCodes.size();
            fcslog.debug("Size of the error register codes table = " + size);
        } catch (IOException ex) {
            fcslog.error("Error in reading file: " + ERROR_REGISTER_CODES_FILENAME + ex.getMessage());
            throw new DeploymentException("Error in reading file: " + ERROR_REGISTER_CODES_FILENAME + ex.getMessage());
        }

    }
    
    public static void loadCommunicationErrorTable() throws DeploymentException {
        try {
            fcslog.debug("COMMUNICATION ERROR TABLE=" + commErrorFile.toString());
            commErrorCodes.load(commErrorFile);
            int size = commErrorCodes.size();
            fcslog.debug("Size of the error register codes table = " + size);
        } catch (IOException ex) {
            fcslog.error("Error in reading file: " + COMM_ERROR_CODES_FILENAME + ex.getMessage());
            throw new DeploymentException("Error in reading file: " + COMM_ERROR_CODES_FILENAME + ex.getMessage());
        }

    }
    
    public static void main(String[] args) throws DeploymentException {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
            String errReg = "10";
            String errorName = CanOpenErrorsTable.errorRegisterCodes.getProperty(errReg);
            System.out.println(errorName);
    }
    
}
