/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * This deviceErrorFile a model for the clamp actuator in the Single Filter Test.
 * The actuator deviceErrorFile used to unlock or release a clamp.
 * To unlock a clamp, the actuator must be ON and to release the clamp
 * it has to be OFF.
 * There deviceErrorFile 2 clamps actuators on the carousel : 
 * one for side X-, one for side X+
 * For the Single Filter Test the actuator will be Maxon Motor EPOS2 24/5.
 * (cf EPOS2_Firmware_Specification_En.pdf)
 * There deviceErrorFile many operation modes for this actuators. 
 * For the Single Filter Test, we will use VELOCITY mode or CURRENT mode.
 * 
 * 
 * @author virieux
 */
//
@Deprecated
public class CanOpenClampActuatorModule extends CanOpenEPOS24 {

//    public CanOpenClampActuatorModule(String aName, int aTickMillis, String nodeID, String serialNB, Motor aMotor, EposMode aMode) {
//        super(aName, aTickMillis, nodeID, serialNB, aMotor, aMode);
//    }

    //int currentValueToMaintain;

    
    

    public CanOpenClampActuatorModule(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {       
        super(aName, aTickMillis, nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }
    
    

//    public CanOpenClampActuatorModule(String aName, int aTickMillis, String nodeID, String serialNB, Motor aMotor, EposMode mode, Map<String, Integer> paramsForHoming, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForCurrent) {       
//        super(aName, aTickMillis, nodeID, serialNB, aMotor, mode, paramsForHoming, paramsForProfilePosition, paramsForCurrent);
//    }
//    public CanOpenClampActuatorModule(String aName, int aTickMillis, 
//            String nodeID, String serialNB, 
//            Map<String, Integer> paramsForHoming, 
//            Map<String, Integer> paramsForProfilePosition, 
//            Map<String, Integer> paramsForCurrent, EposMode aMode, 
//            int currentValue, int currentValueToMaintain) {
//        super(aName, aTickMillis, nodeID, serialNB, paramsForHoming, paramsForProfilePosition, paramsForCurrent, aMode, currentValue);
//        this.currentValueToMaintain = currentValueToMaintain;
//    }

    
    

//    public CanOpenClampActuatorModule(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming, EposMode aMode) {       
//        super(aName, aTickMillis, nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming, aMode);
//    }

    
    
    
//    public void setMode(String modeInString) {       
//        this.mode = EposMode.valueOf(modeInString);
//    }

 
    


    
 
    
    /**
     * This is the user name of the command ON in single filter test.
     * @return
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException 
     */
    public String unclamp() throws SDORequestException, BadCommandException, ErrorInCommandExecutionException {
        return on();
    }
    
    public StatusDataPublishedByClampActuator getStatusData() {
        return FcsUtils.createStatusDataPublishedByClampActuator(this);
    }

}
