/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * This represents the gateway to the pluto PLC involved in the camera protection system.
 * The sensors are read through this gateway.
 * We read the data from the gateway byte by byte. Usually we read 2 bytes at one time.
 * This class has to be extended to fit the real hardware control software needs and the 
 * simulator.
 * 
 * @author virieux
 */
public abstract class PlutoGatewayModule extends Module implements PlutoGatewayInterface {
    
   protected static final Logger fcslog = FcsUtils.log;

   public String[] hexaValues;
   protected int analogValue;
    
   //updatingValue is true while we are reading the value sent by the Sensor
   //this could take some time
   protected volatile boolean updatingValues = false;
   protected final Lock lock = new ReentrantLock();
   protected final Condition valueUpdated = lock.newCondition();

    public PlutoGatewayModule(String string, int i) {
        super(string, i);
        this.hexaValues = new String[2];
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.analogValue = 0;
    }
   
   
        
    @Override
   public void initModule() {
   }
   
     /**
     * @return the hexa values.
     */
    public String[] getHexaValues() {
       lock.lock();
       try {
           while (updatingValues) {
                try {
                    //TODO put a timeout
                    valueUpdated.await();
                } catch (InterruptedException ex) {
                    fcslog.error(getName() + ex.getMessage());
      
                }
           }
           return this.hexaValues;
       } finally {
           lock.unlock();
       }
    }
    
         /**
     * @return the analog value.
     */
    public int getAnalogValue() {
       lock.lock();
       try {
           while (updatingValues) {
                try {
                    //TODO put a timeout
                    valueUpdated.await();
                } catch (InterruptedException ex) {
                    fcslog.error(getName() + ex.getMessage());
      
                }
           }
           return this.analogValue;
       } finally {
           lock.unlock();
       }
    }
    

    public void updateValues() throws FcsHardwareException  {
       lock.lock();       
       
       
       try {
            updatingValues = true;
            this.hexaValues = readNewHexaValues();
            fcslog.finest(getName() + " HEXA VALUE READ: hexaValues[0]=" + this.hexaValues[0]
                + " hexaValues[1]=" + this.hexaValues[1]);

       } finally {
           

           updatingValues = false;
           valueUpdated.signal();
           lock.unlock();
           
       }
    }
    
    
    public void updateAnalogValue() throws FcsHardwareException  {
       lock.lock();       
       
       
       try {
            updatingValues = true;
            this.analogValue = readNewAnalogValue();
            fcslog.finest(getName() + " ANALOG VALUE READ=" + this.analogValue);

       } finally {
           
           updatingValues = false;
           valueUpdated.signal();
           lock.unlock();
           
       }
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/byte no1=");sb.append(String.valueOf(this.hexaValues[0]));
        sb.append("/byte no2=");sb.append(String.valueOf(this.hexaValues[1]));
        sb.append("/analogValue=");sb.append(String.valueOf(this.analogValue));
        return sb.toString();
    }

    
}
