/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS24;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenPlutoGateway;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This is a model for online clamp which holds a filter
 * when it is at ONLINE position.
 * The online clamps are part of the autochanger subsystem.
 * There is 3 online clamps.
 * @author virieux
 */
public class OnlineClampModule extends MobileItemModule {
    
    CanOpenEPOS24 onlineClampController;
    Map<String,Integer> paramsForCurrentToLock;
    Map<String,Integer> paramsForCurrentToUnlock;
    int currentToLock;
    int currentToUnlock;
    int currentToClamp;
    
    PlutoGatewayModule plutoGateway; // where the brake is connected
    
    FcsEnumerations.LockStatus lockStatus;

    public OnlineClampModule(String moduleName, int aTickMillis) {
        super(moduleName, aTickMillis);
    }

    public OnlineClampModule(String moduleName, int aTickMillis,            
            int currentToLock, 
            int currentToUnlock,
            int currentToClamp,
            Map<String, Integer> paramsForCurrentToLock, 
            Map<String, Integer> paramsForCurrentToUnlock) {
        super(moduleName, aTickMillis);
        this.paramsForCurrentToLock = paramsForCurrentToLock;
        this.paramsForCurrentToUnlock = paramsForCurrentToUnlock;
        this.currentToLock = currentToLock;
        this.currentToUnlock = currentToUnlock;
        this.currentToClamp = currentToClamp;
    }
    
    
    
    
    @Override
    public void initModule() {
        super.initModule();
        plutoGateway = (CanOpenPlutoGateway) this.getModule("plutoGateway");
        onlineClampController = (CanOpenEPOS24) this.getModule("onlineClampController");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, description="Returns true if hardware is connected and ready.")
    @Override
    public boolean isHardwareReady() {
        return ((MainModule) this.getModule("main")).isHardwareReady();
    }
    

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
    //TODO change this
        switch(action) {  
            case LOCK_ONLINECLAMP :
                onlineClampController.enable();
                onlineClampController.changeMode(CanOpenEPOS.EposMode.CURRENT);
                onlineClampController.writeParameters(paramsForCurrentToLock);
                onlineClampController.writeCurrent(this.currentToLock);
                break;
                
           case UNLOCK_ONLINECLAMP :
                onlineClampController.enable();
                onlineClampController.changeMode(CanOpenEPOS.EposMode.CURRENT);
                onlineClampController.writeParameters(paramsForCurrentToUnlock);
                onlineClampController.writeCurrent(this.currentToUnlock);
                
                break;
                }
    }

    @Override
    public void stopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
}
