/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.MobileItemAction;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This is a model for the carrier in the loader.
 * @author virieux
 */
public class LoaderCarrierModule extends MobileItemModule {
    protected NumericSensor storagePositionSensor;
    protected NumericSensor handoffPositionSensor;
    //private final String plutoGatewayName;
    private LoaderModule loader;
    
    final Condition stateUpdated = lock.newCondition();
    
     /* This is used when we update the clamp clampState with the values returned 
     *  by the sensors.
     */
    protected volatile boolean updatingState = false;
    private boolean atStorage;
    private boolean atHandoff;

    public LoaderCarrierModule(String moduleName, int aTickMillis 
            //String plutoGatewayName
        ) {
        super(moduleName, aTickMillis);
        //this.plutoGatewayName = plutoGatewayName;
        this.atHandoff = false;
        this.atStorage = false;
    }
    
    
    
    @Override
    public void initModule() {
        this.loader = (LoaderModule) this.getModule("loader");
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, description="Returns true if loader hardware is connected and ready.")
    @Override
    public boolean isHardwareReady() {
        return ((LoaderModule) this.getModule("loader")).isHardwareReady();
    }
    
    /**
     * Updates the boolean field empty and returns it.
     * @return empty
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
            description="Read the sensors and return true if a filter is in the loader.")
    public boolean checkFilterPresence() throws FcsHardwareException {
        this.updateStateWithSensors();
        return !this.isEmpty();
    }
    

    
     /**
     * Returns the boolean field empty. 
     * If the empty boolean is being updated and waits 
     * for a response from a sensor, this methods waits until empty is updated.
     * If the field empty is not being updated, it returns immediatly the field empty.
     * 
     * @return empty
     * 
     */
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
                description="Return true if there is no filter in the loader. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        return loader.isEmpty();
    }
    
     /**
     * Returns the boolean field atStorage. 
     * If the atStorage boolean is being updated and waits 
     * for a response from a sensor, this methods waits until atStorage is updated.
     * If the field atStorage is not being updated, it returns immediatly the field atStorage.
     * 
     * @return atStorage
     * 
     */
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
                description="Return true if the carrier is at storage position. This command doesn't read again the sensors.")
    public boolean isAtStoragePosition() {
        lock.lock();
        try {
            while(updatingState) {
                try {
                    this.stateUpdated.await();
                } catch (InterruptedException ex) {
                    fcslog.error(name + ": has been interrupted while waiting for end of update.");
                }

            }
            return atStorage;
            
        } finally {
            lock.unlock();
        }
    }
    
     /**
     * Returns the boolean field atHandoff. 
     * If the atHandoff boolean is being updated and waits 
     * for a response from a sensor, this methods waits until atHandoff is updated.
     * If the field atHandoff is not being updated, it returns immediatly the field atHandoff.
     * 
     * @return atHandoff
     * 
     */
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
                description="Return true if the carrier is at storage position. This command doesn't read again the sensors.")
    public boolean isAtHandoffPosition() {
        lock.lock();
        try {
            while(updatingState) {
                try {
                    this.stateUpdated.await();
                } catch (InterruptedException ex) {
                    fcslog.error(name + ": has been interrupted while waiting for end of update.");
                }

            }
            return atHandoff;
            
        } finally {
            lock.unlock();
        }
    }
    
    /**
     * 
     * @return true if loader is connected on camera
     */
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
                description="Return true if the loader is connected on the camera. This command doesn't read again the sensors.")
    public boolean isConnectedOnCamera() {
        return loader.isConnectedOnCamera();
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
                description="Return true if the autochanger is holding the filter. This command doesn't read again the sensors.")
    public boolean isAutochangerHoldingFilter() {
        return loader.isAutochangerHoldingFilter();
    }   



    public void goToHandOff() {
        
    }

    public void goToStorage() {
        
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() 
            throws Exception {
        this.updateStateWithSensors();
    }
    
    /**
     * This methods updates the carrier state in reading all the carrier sensors.
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        loader.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) 
            throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (action.equals(FcsEnumerations.MobileItemAction.MOVELOADERCARRIERTOHANDOFF)) {
            //TODO what do we do in that case ?

        } else if (action.equals(FcsEnumerations.MobileItemAction.MOVELOADERCARRIERTOSTORAGE)) {
            //TODO what do we do in that case ?
        } else if (action.equals(FcsEnumerations.MobileItemAction.OPENLOADERHOOKS)) {
            //TODO what do we do in that case ?

        } else throw new IllegalArgumentException(getName() + "Action on loader carrier must be MOVELOADERCARRIERTOHANDOFF or MOVELOADERCARRIERTOSTORAGE");
    }
    
    @Override
    public void stopAction(MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
    }

    public void initializeHardware() {
    }


    
    
}
