/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * For the single-filter-test, a model for the actuator which opens 
 * and close the latches to release or hold a filter.
 * @author virieux
 */
public abstract class LatchActuatorModule extends Module  {

    protected static final Logger fcslog = FcsUtils.log;
    protected double currentLimitInVolt; // to limit the current sent to the motor
    protected double speedVoltageInVolt; // to start the motor
    boolean close;
    
    //for the GUI
    public int speedVoltageMinValue;
    public int speedVoltageMaxValue;

    public LatchActuatorModule(String aName, int aTickMillis, double currentLimitInVolt, double speedVoltageInVolt, int speedVoltageMinValue, int speedVoltageMaxValue) {
        super(aName, aTickMillis);
        this.currentLimitInVolt = currentLimitInVolt;
        this.speedVoltageInVolt = speedVoltageInVolt;
        this.speedVoltageMinValue = speedVoltageMinValue;
        this.speedVoltageMaxValue = speedVoltageMaxValue;
    }


    
    
    

    /**************************************************************************************************/
    /********************** SETTERS AND GETTERS  ******************************************************/
    /**************************************************************************************************/
    
    public double getCurrentLimitInVolt() {
        return currentLimitInVolt;
    }

    public void setCurrentLimitInVolt(double currentLimitInVolt) {
        this.currentLimitInVolt = currentLimitInVolt;
    }

    public double getSpeedVoltageInVolt() {
        return speedVoltageInVolt;
    }

    public void setSpeedVoltageInVolt(int speedVoltageInVolt) {
        this.speedVoltageInVolt = speedVoltageInVolt;
    }

    public int getSpeedVoltageMaxValue() {
        return speedVoltageMaxValue;
    }

    public void setSpeedVoltageMaxValue(int speedVoltageMaxValue) {
        this.speedVoltageMaxValue = speedVoltageMaxValue;
    }

    public int getSpeedVoltageMinValue() {
        return speedVoltageMinValue;
    }

    public void setSpeedVoltageMinValue(int speedVoltageMinValue) {
        this.speedVoltageMinValue = speedVoltageMinValue;
    }




    



    
    


    /**************************************************************************************************/
    /********************** END OF SETTERS AND GETTERS  ***********************************************/
    /**************************************************************************************************/
    
    /**
     * This is the command that has to be sent to the latch actuator to open the latch (same as unlock it).
     * @return
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException 
     */
    public abstract String open() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException;

    /**
     * This is the command that has to be sent to the latch actuator to close the latch it (same as lock it).
     * @return
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException 
     */
    public abstract String close() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException;
    
    /**
     * Power off the latch actuator.
     * @return
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException 
     */
    public abstract String powerOff() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException;





    
}
