package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterLocation;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * This is a model for an optical filter for the camera.
 * 
 */
public class Filter implements Configurable {
    
        protected static final Logger fcslog = FcsUtils.log;
	
	private Integer filterID;
	private String name;
	private double weight;
	private FilterLocation filterLocation = FilterLocation.UNKNOWN;
	
	//for Hibernate
	public Filter () {}

	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}

        /**
         * 
         * @return true if the filter is held by the carousel.
         */
	public boolean isOnCarousel() {
		return this.filterLocation == FilterLocation.ONCAROUSEL;
	}
		
        /**
         * 
         * @return true if the filter is held by the autochanger.
         */
	public boolean isOnAutoChanger() {
		return this.filterLocation == FilterLocation.ONAUTOCHANGER;
	}
	
        
        /**
         * 
         * @return true if the filter is out the camera.
         */
	public boolean isOut() {
		return this.filterLocation == FilterLocation.OUT;
	}
	
        /**
         * 
         * @return true if the location of the filter is unknown.
         */
	public boolean isUnknown() {
		return this.filterLocation == FilterLocation.UNKNOWN;
	}

	public FilterLocation getFilterLocation() {
		return filterLocation;
	}

	public void setFilterLocation(FilterLocation filterLocation) {
		this.filterLocation = filterLocation;
	}

	public Integer getFilterID() {
		return filterID;
	}

	public void setFilterID(Integer filterID) {
		this.filterID = filterID;
	}

	public double getWeight() {
		return weight;
	}

	public void setWeight(double weight) {
		this.weight = weight;
	}
        
        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            sb.append("/Weight=");sb.append(weight);
            return sb.toString();
        }

    @Override
    public void setEnvironment(Environment e) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public Environment getEnvironment() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void change(String string, Object o) throws Exception {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }



}
