/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.FilterLatchModule;
import org.lsst.ccs.subsystems.fcs.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.LoaderHookModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderCarrierConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderHookConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ActuatorConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ClampConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.testbench.LoaderTestBenchMainModule;
import org.lsst.ccs.utilities.logging.Logger;

public class FcsUtils {
    public static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");

    public static SingleFilterTestConfig createSingleFilterTestConfig(SftMainModule main) {
        SftCarouselModule carouselModule = main.getCarouselModule();
        boolean controlRealHardware = main.controlRealHardware();
        SftAutoChangerModule autochanger = main.getAutoChangerModule();
        return new SingleFilterTestConfig(controlRealHardware, FcsUtils.createClampConfig(carouselModule.getClampXminus()), FcsUtils.createClampConfig(carouselModule.getClampXplus()), FcsUtils.createActuatorConfig(carouselModule.getClampActuatorXminus()), FcsUtils.createActuatorConfig(carouselModule.getClampActuatorXplus()), FcsUtils.createActuatorConfig(autochanger.getLatchXminus().getLatchActuator()), FcsUtils.createActuatorConfig(autochanger.getLatchXplus().getLatchActuator()));
    }

    public static ClampConfig createClampConfig(FilterClampModule filterModule) {
        return new ClampConfig(filterModule.getName(), filterModule.getFilterPositionValueA(), filterModule.getFilterPositionValueB(), filterModule.getFilterPositionValueC(), filterModule.getLockSensorValueA(), filterModule.getLockSensorValueB(), filterModule.getLockSensorValueC(), filterModule.getFilterPositionMinValue(), filterModule.getFilterPositionMaxValue(), filterModule.getLockSensorMinValue(), filterModule.getLockSensorMaxValue());
    }

    public static ActuatorConfig createActuatorConfig(Actuator actuator) {
        return new ActuatorConfig(actuator.getSentCurrentMinValue(), actuator.getSentCurrentMaxValue());
    }

    public static ActuatorConfig createActuatorConfig(LatchActuatorModule actuatorModule) {
        return new ActuatorConfig(actuatorModule.getSpeedVoltageMinValue(), actuatorModule.getSpeedVoltageMaxValue());
    }

    public static LoaderConfig createLoaderConfig(LoaderTestBenchMainModule main) {
        return new LoaderConfig(main.controlRealHardware(), FcsUtils.createLoaderClampConfig(main.getLoader().getClamp()), FcsUtils.createLoaderCarrierConfig(main.getLoader().getCarrier()));
    }

    public static LoaderClampConfig createLoaderClampConfig(LoaderClampModule clamp) {
        return new LoaderClampConfig(clamp.getMinPosition(), clamp.getMaxPosition(), clamp.getTargetPositionToOpen(), clamp.getTargetPositionToClose(), clamp.getTargetPositionToClamp(), clamp.getTimeoutForOpeningHooks(), clamp.getTimeoutForClosingHooks(), clamp.getTimeoutForClampingHooks(), clamp.getTimeoutForGoingToHomePosition(), FcsUtils.createLoaderHookConfig(clamp.getHook1()), FcsUtils.createLoaderHookConfig(clamp.getHook2()), FcsUtils.createLoaderHookConfig(clamp.getHook3()), FcsUtils.createLoaderHookConfig(clamp.getHook4()));
    }

    public static LoaderHookConfig createLoaderHookConfig(LoaderHookModule hook) {
        LoaderHookConfig loaderHookConfig = new LoaderHookConfig(hook.getName(), hook.getLockSensor().getDigitalValue(), hook.getUnlockSensor().getDigitalValue(), hook.isInError());
        return loaderHookConfig;
    }

    public static LoaderCarrierConfig createLoaderCarrierConfig(LoaderCarrierModule carrier) {
        return new LoaderCarrierConfig(carrier.getName());
    }

    public static StatusDataPublishedByBasicAutoChanger createStatusDataPublishedByBasicAutoChanger(BasicAutoChangerModule basicAutoChanger) {
        StatusDataPublishedByBasicAutoChanger status = new StatusDataPublishedByBasicAutoChanger();
        status.setName(basicAutoChanger.getName());
        status.setFilterOnTrucksName(basicAutoChanger.getFilterOnTrucksName());
        status.setTrucksEmpty(basicAutoChanger.isTrucksEmpty());
        status.setRailSensorStandbackXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbackXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbyXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandby().getDigitalValue());
        status.setRailSensorStandbyXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandby().getDigitalValue());
        status.setMovingToStandback(basicAutoChanger.isMovingToStandback());
        status.setMovingToStandby(basicAutoChanger.isMovingToStandby());
        return status;
    }

    public static StatusDataPublishedByAutoChanger createStatusDataPublishedByAutoChanger(AutoChangerModule autochanger) {
        StatusDataPublishedByAutoChanger status = new StatusDataPublishedByAutoChanger();
        status.setName(autochanger.getName());
        status.setFilterOnTrucksName(autochanger.getFilterOnTrucksName());
        status.setTrucksEmpty(autochanger.isTrucksEmpty());
        status.setTrucksLocation(autochanger.getTrucksLocation());
        status.setIsLockedOnlineClamp(autochanger.getOnlineClamp().isLocked());
        return status;
    }

    public static StatusDataPublishedByCarousel createStatusDataPublishedByCarousel(CarouselModule carousel) {
        int nbSockets = carousel.getNbSockets();
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel(nbSockets);
        status.setRotationInDegrees(carousel.getPosition());
        status.setIsLocked(carousel.isLocked());
        int i = 0;
        while (i < nbSockets) {
            status.setFilterName(i, carousel.getSockets()[i].getFilter() == null ? "empty" : carousel.getSockets()[i].getFilter().getName());
            StringBuilder sb = new StringBuilder("Socket number: ");
            sb.append(i).append("\n");
            sb.append(carousel.getSockets()[i].toString());
            ++i;
        }
        status.setFilterInStandbyName(carousel.getFilterInStandbyName());
        status.setActuatorXminusState(carousel.getClampActuatorXminus().toString());
        status.setActuatorXplusState(carousel.getClampActuatorXplus().toString());
        return status;
    }

    public static StatusDataPublishedByClamp createStatusDataPublishedByClamp(FilterClampModule clamp) {
        StatusDataPublishedByClamp status = new StatusDataPublishedByClamp();
        status.setName(clamp.getName());
        status.setClampState(clamp.getClampState().toString());
        status.setFilterPositionInClamp(clamp.getFilterPresenceStatus().toString());
        status.setFilterPositionSensorValue(clamp.getFilterPresenceSensor().getValue());
        status.setLockSensorValue(clamp.getLockSensor().getValue());
        status.setLockStatus(clamp.getLockStatus().toString());
        status.setTemperature(clamp.getTemperature());
        return status;
    }

    public static StatusDataPublishedByClampActuator createStatusDataPublishedByClampActuator(Actuator actuator) {
        StatusDataPublishedByClampActuator status = new StatusDataPublishedByClampActuator();
        status.setName(actuator.getName());
        status.setReadValue(actuator.getReadValue());
        status.setSentValue(actuator.getSentValue());
        status.setOn(actuator.isOn());
        return status;
    }

    public static StatusDataPublishedByLatch createStatusDataPublishedByLatch(FilterLatchModule latch) {
        StatusDataPublishedByLatch status = new StatusDataPublishedByLatch();
        status.setName(latch.getName());
        status.setLockSensorValue(latch.getLockSensor().getDigitalValue());
        status.setUnlockSensorValue(latch.getUnlockSensor().getDigitalValue());
        status.setFilterPositionSensorValue(latch.getFilterPresenceSensor().getDigitalValue());
        status.setLockStatus(latch.getLockStatus().toString());
        return status;
    }

    public static StatusDataPublishedByLoaderClamp createStatusDataPublishedByLoaderClamp(LoaderClampModule clamp) {
        StatusDataPublishedByLoaderClamp status = new StatusDataPublishedByLoaderClamp();
        status.setName(clamp.getName());
        status.setPosition(clamp.getPosition());
        status.setClampState(clamp.getLockStatus().toString());
        status.setStatusPublishedByHook1(FcsUtils.createStatusDataPublishedByLoaderHook(clamp.getHook1()));
        status.setStatusPublishedByHook2(FcsUtils.createStatusDataPublishedByLoaderHook(clamp.getHook2()));
        status.setStatusPublishedByHook3(FcsUtils.createStatusDataPublishedByLoaderHook(clamp.getHook3()));
        status.setStatusPublishedByHook4(FcsUtils.createStatusDataPublishedByLoaderHook(clamp.getHook4()));
        return status;
    }

    private static StatusDataPublishedByLoaderHook createStatusDataPublishedByLoaderHook(LoaderHookModule hook) {
        StatusDataPublishedByLoaderHook status = new StatusDataPublishedByLoaderHook(hook.getName(), hook.getLockSensor().getDigitalValue(), hook.getUnlockSensor().getDigitalValue(), hook.isInError(), hook.getLockStatus().toString());
        return status;
    }

    public static String binaryToHex(String bin) {
        int binaryToInt = Integer.parseInt(bin, 2);
        return Integer.toHexString(binaryToInt);
    }

    public static String hexToBinary(String Hex) {
        int integer = Integer.parseInt(Hex, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%08d", Integer.parseInt(bin));
    }
}

