/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.HygrometrySensor;
import org.lsst.ccs.subsystems.fcs.common.PressureSensor;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.testbench.CanOpenLED;
import org.lsst.ccs.subsystems.fcs.testbench.InclinometerModule;
import org.lsst.ccs.subsystems.fcs.testbench.Scale1ProtoPivotingFrame;

public class Scale1ProtoTestBenchMainModule
extends MainModule {
    private final HygrometrySensor hygrometrySensor;
    private final PressureSensor pressureSensor;
    private final Thermometer thermometer;
    private final Scale1ProtoPivotingFrame pivotingFrame;
    private final InclinometerModule inclinometer;
    private final CanOpenLED led;
    private final CanOpenLED fakeLed;
    private final Thermometer fakeSensor;
    public double temperature;
    public double pressure;
    public double hygrometry;

    public Scale1ProtoTestBenchMainModule(String aName, int aTickMillis, BridgeToHardware bridge, HygrometrySensor hygrometrySensor, PressureSensor pressureSensor, Thermometer thermometer, CanOpenLED led, CanOpenLED fakeLed, Thermometer fakeSensor, Scale1ProtoPivotingFrame pivotingFrame, InclinometerModule inclinometer) {
        super(aName, aTickMillis, bridge);
        this.hygrometrySensor = hygrometrySensor;
        this.pressureSensor = pressureSensor;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
        this.pivotingFrame = pivotingFrame;
        this.inclinometer = inclinometer;
    }

    public double readHygrometry() throws FcsHardwareException {
        this.hygrometry = this.hygrometrySensor.readHygrometry();
        return this.hygrometry;
    }

    public double readPressure() throws FcsHardwareException {
        this.pressure = this.pressureSensor.readPressure();
        return this.pressure;
    }

    public double readTemperature() throws FcsHardwareException {
        this.temperature = this.thermometer.readTemperature();
        return this.temperature;
    }

    public String turnOnLED() throws SDORequestException, HardwareNotDetectedException {
        return this.led.turnON();
    }

    public String turnOffLED() throws SDORequestException, HardwareNotDetectedException {
        return this.led.turnOFF();
    }

    public String turnOnFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return this.fakeLed.turnON();
    }

    public String turnOffFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return this.fakeLed.turnOFF();
    }

    public double readFakeSensor() throws FcsHardwareException, BadCommandException {
        return this.fakeSensor.readTemperature();
    }

    public void rotateCamera(long angle) {
        this.pivotingFrame.rotateCamera(angle);
    }

    public void rotateX(long angle) {
        this.pivotingFrame.rotateX(angle);
    }

    public void tick() {
        try {
            this.readTemperature();
            this.readPressure();
            this.readHygrometry();
            this.publish("temperature", this.temperature);
            this.publish("hygrometry", this.hygrometry);
            this.publish("pressure", this.pressure);
        }
        catch (FcsHardwareException fcsHardwareException) {
            log.debug((Object)(String.valueOf(this.getName()) + "couldn't read sensors"), new String[0]);
        }
    }
}

