/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.List;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.common.GenericLatch;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;

public class SimuSftCarouselModule
extends SftCarouselModule {
    public SimuSftCarouselModule(String aName, int aTickMillis, Motor carouselMotor, GenericLatch brake, int nbSockets, List<CarouselSocket> socketsList) {
        super(aName, aTickMillis, carouselMotor, brake, nbSockets, socketsList);
    }

    @Override
    public void updateStateWithSensors() throws BadCommandException, FcsHardwareException {
        if (this.getSocketAtStandby() == null) {
            throw new BadCommandException("Unable to read sensors when there is no socket at standby.");
        }
        this.getSocketAtStandby().updateClampsStateWithSensorsFromSDO();
        Filter dummyFilter = ((SftMainModule)this.getModule("main")).getDummyFilter();
        if (this.getSocketAtStandby().isClampedOnFilter() || this.getSocketAtStandby().isUnclampedOnFilter()) {
            this.getSocketAtStandby().putFilterOnSocket(dummyFilter);
        } else if (this.getSocketAtStandby().getFilter() != null) {
            this.getSocketAtStandby().removeFilter();
        }
    }

    @Override
    public void updateClampsStateWithSensors() throws BadCommandException, FcsHardwareException {
        this.updateClampsStateWithSensorsFromSDO();
    }
}

