/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuEPOSControllerModule
extends Module
implements EPOSController {
    SimuPlutoGateway plutoGateway;
    LoaderClampModule clamp;
    public boolean on;
    CanOpenEPOS.EposMode mode;
    int absolutePosition;
    int targetPosition;
    int position;
    int current;

    public SimuEPOSControllerModule(String string, int i) {
        super(string, i);
    }

    public void initModule() {
        this.plutoGateway = (SimuPlutoGateway)this.getModule("plutoGateway");
        this.clamp = (LoaderClampModule)this.getModule("clamp");
    }

    public String changeMode(String modeInString) throws SDORequestException {
        CanOpenEPOS.EposMode newMode = CanOpenEPOS.EposMode.valueOf(modeInString.trim().toUpperCase());
        return this.changeMode(newMode);
    }

    @Override
    public String changeMode(CanOpenEPOS.EposMode newMode) throws SDORequestException {
        this.mode = newMode;
        return String.valueOf(this.getName()) + " mode changed to=" + newMode.toString();
    }

    @Override
    public boolean checkMotorParameters() throws EPOSConfigurationException {
        return true;
    }

    @Override
    public void defineAbsolutePosition(int position) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        this.position = position;
    }

    @Override
    public void writeParameters(CanOpenEPOS.EposMode mode) throws SDORequestException, ErrorInCommandExecutionException {
    }

    @Override
    public void writeTargetPosition(int position) throws BadCommandException, SDORequestException {
        this.position = position;
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) throws SDORequestException {
    }

    @Override
    public void writeCurrent(int aValue) throws BadCommandException, SDORequestException {
        this.current = aValue;
    }

    @Override
    public String on() throws SDORequestException, BadCommandException, ErrorInCommandExecutionException {
        try {
            Thread.sleep(2 * this.tickMillis);
        }
        catch (InterruptedException ex) {
            log.warning((Object)(String.valueOf(this.getName()) + ":Error in command ON " + ex.toString()), new String[0]);
            return String.valueOf(this.getName()) + ":command OFF interrupted";
        }
        switch (this.mode) {
            case PROFILE_POSITION: {
                if (this.position == this.clamp.getTargetPositionToOpen()) {
                    this.plutoGateway.simulateLoaderClampIsUnLocked();
                    break;
                }
                if (this.position == this.clamp.getTargetPositionToClose()) {
                    this.plutoGateway.simulateLoaderClampIsLocked();
                    break;
                }
                if (this.position == this.clamp.getTargetPositionToClamp()) {
                    this.plutoGateway.simulateLoaderClampIsLocked();
                    break;
                }
                log.debug((Object)(String.valueOf(this.getName()) + " ERROR in command ON: the position has a bad value."), new String[0]);
                break;
            }
            case CURRENT: {
                if (this.current == this.clamp.getCurrentToGoHome()) {
                    this.plutoGateway.simulateLoaderClampIsUnLocked();
                    break;
                }
                if (this.current != this.clamp.getCurrentToClose()) break;
                this.plutoGateway.simulateLoaderClampIsLocked();
                break;
            }
            default: {
                log.debug((Object)(String.valueOf(this.name) + " ERROR in command ON: mode has to be CURRENT or PROFILE_POSITION."), new String[0]);
            }
        }
        return String.valueOf(this.name) + " is ON";
    }

    @Override
    public String off() throws SDORequestException, BadCommandException {
        return String.valueOf(this.name) + " is OFF";
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public boolean isOff() {
        return !this.on;
    }

    @Override
    public int getReadValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getSentValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getSentCurrentMinValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getSentCurrentMaxValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isTargetPositionReached(int targetPosition) {
        return this.position == targetPosition;
    }

    @Override
    public int readPosition() throws SDORequestException {
        return this.position;
    }

    @Override
    public String enable() throws SDORequestException {
        return String.valueOf(this.name) + "IS ENABLED";
    }

    @Override
    public int readCurrent() throws BadCommandException, SDORequestException {
        return this.current;
    }
}

