/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.common.RunningWay;
import org.lsst.ccs.utilities.logging.Logger;

@Deprecated
public class RunningState
implements EngineState {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.fcs.simulation");

    public String toString() {
        return "running";
    }

    @Override
    public double computeDisplacement(Motor motor, double period, RunningWay runningWay) {
        double displacement = 0.0;
        double diff = System.currentTimeMillis() - motor.getStateChangeTime();
        if (diff < motor.getPeriod()) {
            displacement = motor.getNominalVelocity() * period / 1000.0;
            if (runningWay == RunningWay.POSITIVE) {
                displacement = motor.getNominalVelocity() * period / 1000.0;
            } else if (runningWay == RunningWay.NEGATIVE) {
                displacement = -(motor.getNominalVelocity() * period / 1000.0);
            } else {
                throw new IllegalArgumentException(" [RunningState] ERROR : wrong running way.");
            }
            return displacement;
        }
        motor.stop();
        displacement = motor.getRequiredPosition() - motor.getPosition();
        return displacement;
    }

    @Override
    public String error(Motor motor) {
        motor.setStateChangeTime(System.currentTimeMillis());
        motor.setEngineState(ERROR);
        return "ERROR";
    }

    @Override
    public String go(Motor motor, double t, RunningWay runningWay) {
        return null;
    }

    @Override
    public String stop(Motor motor) {
        motor.setStateChangeTime(System.currentTimeMillis());
        motor.setEngineState(STOP);
        String message = String.valueOf(motor.getName()) + " [RunningState] motor stopped";
        log.info((Object)message, new String[0]);
        return message;
    }
}

