/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.drivers.CommandDispenser;
import org.lsst.ccs.subsystems.fcs.errors.CWrapperNotConnected;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.beanutils.WrappedException;
import org.lsst.ccs.utilities.logging.Logger;

abstract class FcsTcpProxy
extends Module {
    private final int portNumber;
    private ServerSocket serverSock;
    private Thread readerThread;
    protected volatile boolean stopped = true;
    protected volatile boolean stopping = false;
    protected volatile boolean tcpServerStarted = false;
    protected ClientContext clientContext;
    private CommandDispenser commandDispenser;
    protected static final Logger fcslog = FcsUtils.log;
    protected final Lock lock = new ReentrantLock();
    protected final Condition hardwareBooted = this.lock.newCondition();

    public FcsTcpProxy(String aName, int aTickMillis, int portNumber) {
        super(aName, aTickMillis);
        this.portNumber = portNumber;
    }

    public boolean isTcpServerStarted() {
        return this.tcpServerStarted;
    }

    public void initModule() {
        this.stopped = false;
        this.stopping = false;
        this.tcpServerStarted = false;
        this.commandDispenser = new CommandDispenser();
    }

    public void start() {
        this.startServer();
        this.startThreadReader();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Starts the tcp server.")
    public void startServer() {
        try {
            this.serverSock = new ServerSocket(this.portNumber);
            fcslog.info((Object)(String.valueOf(this.name) + ":SERVER STARTED ON PORT:" + this.portNumber), new String[0]);
        }
        catch (IOException e) {
            fcslog.error((Object)(String.valueOf(this.name) + ":server not started"), (Throwable)e, new String[0]);
            throw new WrappedException((Throwable)e);
        }
        try {
            fcslog.info((Object)(String.valueOf(this.name) + ":WAITING FOR C-WRAPPER CLIENT..."), new String[0]);
            fcslog.debug((Object)(String.valueOf(this.name) + ":DEBUGGING MODE"), new String[0]);
            Socket sock = this.serverSock.accept();
            fcslog.info((Object)(String.valueOf(this.name) + ":socket accept on " + this.portNumber), new String[0]);
            BufferedReader reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), "ISO-8859-1"), 256);
            String nameAndProtocol = reader.readLine();
            if (nameAndProtocol == null) {
                fcslog.error((Object)(String.valueOf(this.name) + ": nameAndProtocol is null : that should not happen."), new String[0]);
            } else {
                String[] words = nameAndProtocol.split(" ");
                String cname = words[0];
                this.clientContext = new ClientContext(cname, sock, reader, sock.getOutputStream());
                fcslog.info((Object)(String.valueOf(this.name) + ":REGISTERED : " + cname), new String[0]);
                this.tcpServerStarted = true;
                this.stopped = false;
            }
        }
        catch (IOException e) {
            fcslog.error((Object)(String.valueOf(this.name) + " unexpected "), (Throwable)e, new String[0]);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Starts to listen to the tcp client.")
    public void startThreadReader() {
        try {
            if (!this.isTcpServerStarted()) {
                throw new BadCommandException(String.valueOf(this.name) + " has to be started first.");
            }
            Runnable readingFromTcpProxy = new Runnable(){

                @Override
                public void run() {
                    while (!FcsTcpProxy.this.stopped) {
                        try {
                            String readline = FcsTcpProxy.this.clientContext.reader.readLine();
                            if (readline == null) {
                                if (FcsTcpProxy.this.stopping) {
                                    fcslog.info((Object)(String.valueOf(FcsTcpProxy.this.name) + " : CWrapper is stopped."), new String[0]);
                                    continue;
                                }
                                fcslog.error((Object)(String.valueOf(FcsTcpProxy.this.name) + " :nameAndProtocol is null : that should not happen."), new String[0]);
                                continue;
                            }
                            fcslog.finest((Object)(String.valueOf(FcsTcpProxy.this.name) + ":message read from socket=" + readline), new String[0]);
                            if (readline.startsWith("emcy")) {
                                FcsTcpProxy.this.processEmcyMessage(readline);
                                continue;
                            }
                            if (readline.startsWith("Unknown")) {
                                FcsTcpProxy.this.processUnknownCommand(readline);
                                continue;
                            }
                            String[] words = readline.split(",");
                            String commandWord = words[0];
                            String nodeID = words[1];
                            if (commandWord.equals("boot")) {
                                fcslog.info((Object)(String.valueOf(FcsTcpProxy.this.name) + ":boot command received for node: " + nodeID), new String[0]);
                                FcsTcpProxy.this.processBootMessage(nodeID);
                                continue;
                            }
                            String token = readline.startsWith("sync") ? "sync" : String.valueOf(commandWord) + nodeID;
                            fcslog.finest((Object)("Corresponding token=" + token), new String[0]);
                            if (FcsTcpProxy.this.commandDispenser.isTokenUsed(token)) {
                                fcslog.finest((Object)("Response to a registred command:" + readline), new String[0]);
                                try {
                                    FcsTcpProxy.this.commandDispenser.registerResponse(token, readline);
                                }
                                catch (Exception ex) {
                                    fcslog.error((Object)(String.valueOf(FcsTcpProxy.this.name) + ":Error in registering response to command :" + readline), ex.getCause(), new String[0]);
                                }
                                continue;
                            }
                            fcslog.warning((Object)(String.valueOf(FcsTcpProxy.this.name) + ":Unsynchronous message read from tcpProxy=" + readline), new String[0]);
                        }
                        catch (IOException iOException) {
                            fcslog.error((Object)(String.valueOf(FcsTcpProxy.this.name) + ": Error in Thread reading from the tcp client."), new String[0]);
                        }
                    }
                }
            };
            fcslog.info((Object)(String.valueOf(this.name) + ":STARTING Thread reader"), new String[0]);
            this.readerThread = new Thread(readingFromTcpProxy);
            this.readerThread.start();
        }
        catch (BadCommandException ex) {
            fcslog.error((Object)(String.valueOf(this.name) + " tcp server has to be started before startThreadReader."), (Throwable)ex, new String[0]);
            this.getSubsystem().raiseAlarm(ex.toString());
        }
    }

    public void shutdownNow() {
        super.shutdownNow();
        this.stopServer();
    }

    public void stopServer() {
        if (!this.tcpServerStarted) {
            fcslog.warning((Object)(String.valueOf(this.name) + " is stopped; nothing to stop."), new String[0]);
            return;
        }
        fcslog.info((Object)(String.valueOf(this.name) + ": ABOUT TO STOP TCP server....."), new String[0]);
        fcslog.finest((Object)("clientName=" + this.clientContext.clientName), new String[0]);
        this.stopping = true;
        try {
            this.call(this.clientContext.clientName, "quit");
        }
        catch (CanOpenCallTimeoutException ex) {
            String msg = String.valueOf(this.name) + ": could not stop Cwrapper.";
            fcslog.error((Object)msg, new String[0]);
            this.getSubsystem().raiseAlarm(String.valueOf(msg) + ex.getMessage());
        }
        catch (CWrapperNotConnected ex) {
            String msg = String.valueOf(this.name) + ": could not stop because CWrapper is not connected.";
            fcslog.error((Object)msg, new String[0]);
            this.getSubsystem().raiseAlarm(String.valueOf(msg) + ex.getMessage());
        }
        this.stopped = true;
        this.readerThread.interrupt();
        try {
            this.serverSock.close();
            this.tcpServerStarted = false;
            fcslog.info((Object)(String.valueOf(this.name) + ": Subsystem " + this.getSubsystem().getName() + " TCPIP SERVER STOPPED:"), new String[0]);
        }
        catch (IOException iOException) {
            fcslog.error((Object)(String.valueOf(this.name) + " : stop method does not work properly when closing socket"), new String[0]);
        }
        try {
            this.clientContext.reader.close();
            this.clientContext.writer.close();
            this.clientContext.socket.close();
        }
        catch (IOException iOException) {
            fcslog.error((Object)(String.valueOf(this.name) + " : stop method does not work properly"), new String[0]);
        }
    }

    public synchronized boolean isReady(String clientName) {
        if (clientName == null) {
            throw new IllegalArgumentException("Client name can't be null.");
        }
        if (this.clientContext == null || this.clientContext.clientName == null) {
            return false;
        }
        if (this.stopped) {
            return false;
        }
        if (!this.tcpServerStarted) {
            return false;
        }
        fcslog.debug((Object)(String.valueOf(this.name) + "client name:= " + this.clientContext.clientName + "#"), new String[0]);
        return this.clientContext.clientName.equals(clientName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object call(String clientName, String command) throws CWrapperNotConnected, CanOpenCallTimeoutException {
        fcslog.finest((Object)(" CALL :" + clientName + " " + command), new String[0]);
        if (this.clientContext == null) {
            throw new CWrapperNotConnected(this.portNumber, clientName);
        }
        if (this.stopped) {
            throw new IllegalStateException(String.valueOf(this.name) + ":textTCP module stopped");
        }
        String sentCommand = String.valueOf(command) + "\r\u0000\n";
        fcslog.finest((Object)(String.valueOf(this.name) + ":Sent command=" + command), new String[0]);
        this.clientContext.writer.write(sentCommand, 0, sentCommand.length());
        this.clientContext.writer.flush();
        if (!command.startsWith("rsdo") && !command.startsWith("wsdo") && !command.startsWith("info") && !command.startsWith("sync") && !command.startsWith("srtr")) return "asynchronous command sent:" + command;
        String commandToken = this.commandDispenser.register(command);
        try {
            long timeout = 2 * this.tickMillis;
            String string = this.commandDispenser.getCommandResponse(commandToken, timeout);
            this.commandDispenser.remove(commandToken);
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.commandDispenser.remove(commandToken);
                throw throwable;
            }
            catch (IOException e) {
                fcslog.error((Object)(String.valueOf(this.name) + ":ERROR in tcpProxy call method"), new String[0]);
                throw new WrappedException(String.valueOf(this.name) + ":ERROR in tcpProxy call method " + clientName, (Throwable)e);
            }
        }
    }

    abstract void processBootMessage(String var1);

    abstract void processEmcyMessage(String var1);

    abstract void processUnknownCommand(String var1);

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/port=");
        sb.append(this.portNumber);
        return sb.toString();
    }

    protected static class ClientContext {
        String clientName;
        BufferedReader reader;
        BufferedWriter writer;
        Socket socket;

        ClientContext(String name, Socket socket, BufferedReader reader, OutputStream os) {
            try {
                this.clientName = name;
                this.reader = reader;
                this.socket = socket;
                this.writer = new BufferedWriter(new OutputStreamWriter(os, "ISO-8859-1"), 256);
            }
            catch (UnsupportedEncodingException e) {
                fcslog.error((Object)(String.valueOf(name) + ":context not started"), (Throwable)e, new String[0]);
                throw new Error(e);
            }
        }
    }
}

