/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenThermometer
extends CanOpenSensor14bits
implements Thermometer {
    double temperature;

    public CanOpenThermometer(String moduleName, int aTickMillis, String adcName, int numOfAnalogInput) {
        super(moduleName, aTickMillis, adcName, numOfAnalogInput);
    }

    public static double getDoubleValue(String valueInHexa) {
        double temp = 0.0;
        log.debug((Object)("Value in HEXA=" + valueInHexa), new String[0]);
        int valueInt = Integer.parseInt(valueInHexa, 16);
        double voltage = (double)valueInt * 0.3125;
        log.debug((Object)("Input Value read on the ADC:" + valueInt), new String[0]);
        log.debug((Object)("Voltage = " + voltage + " volts"), new String[0]);
        temp = voltage / 10.0 - 273.15;
        return temp;
    }

    @Override
    public double readTemperature() throws HardwareNotDetectedException, SDORequestException {
        try {
            double voltage = this.adc.readVoltage(this.numOfAnalogInput);
            this.temperature = voltage / 10.0 - 273.15;
        }
        catch (ShortResponseToSDORequestException ex) {
            log.warning((Object)(String.valueOf(this.name) + ": could'nt read temperature:" + ex.getMessage()), new String[0]);
        }
        return this.temperature;
    }

    @Override
    public double readTemperatureWithPDO(CanOpenProxy.PDOStorage pdo) throws BadCommandException {
        if (!this.adc.isInitalized()) {
            throw new BadCommandException("Can't read temperature from PDO if Can Open device is not initialized.");
        }
        if (!this.adc.transmissionType.equals("1")) {
            throw new BadCommandException("Transmission type for Can Open device must be 1");
        }
        String hexa = pdo.getVarValue(this.adc.nodeID, Integer.toString(this.numOfAnalogInput));
        return CanOpenThermometer.getDoubleValue(hexa);
    }
}

