/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

public class CanOpenNode {
    private final String nodeID;
    private String type;
    private String vendorID;
    private String productCode;
    private String revisionNB;
    private String serialNB;

    public CanOpenNode(String id) {
        this.nodeID = id;
        this.type = "0";
        this.vendorID = "0";
        this.productCode = "0";
        this.revisionNB = "0";
        this.serialNB = "0";
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public String getType() {
        return this.type;
    }

    public String getVendorID() {
        return this.vendorID;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getRevisionNB() {
        return this.revisionNB;
    }

    public String getSerialNB() {
        return this.serialNB;
    }

    public void setSerialNB(String serialNB) {
        this.serialNB = serialNB;
    }

    public void setNodeInfo(String type, String vendor, String code, String revision, String serial) {
        this.type = type;
        this.vendorID = vendor;
        this.productCode = code;
        this.revisionNB = revision;
        this.serialNB = serial;
    }

    public boolean isADC() {
        return this.type.equals("40191");
    }

    public boolean isDAC() {
        return this.type.equals("80191");
    }

    public boolean isMaxonMotor() {
        return this.type.equals("20192");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Node ID= ");
        sb.append(this.nodeID);
        String dec = String.format(" (in decimal= %d)", Integer.parseInt(this.nodeID, 16));
        sb.append(dec);
        sb.append("/ type=");
        sb.append(this.getType());
        sb.append("/ vendor=");
        sb.append(this.getVendorID());
        sb.append("/ product code=");
        sb.append(this.getProductCode());
        sb.append("/ revision=");
        sb.append(this.getRevisionNB());
        sb.append("/ serial number=");
        sb.append(this.getSerialNB());
        return sb.toString();
    }
}

