/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CanOpenEPOS
extends CanOpenDevice
implements Actuator,
EPOSController {
    public static final Logger fcslog = FcsUtils.log;
    public boolean on;
    public int readValue;
    public int sentValue;
    public int currentValue;
    public int readCurrentValue;
    public int targetPosition;
    public int readActualPosition;
    protected EposMode mode;
    Map<String, Integer> paramsForHoming;
    Map<String, Integer> paramsForProfilePosition;
    Map<String, Integer> paramsForProfileVelocity;
    Map<String, Integer> paramsForPosition;
    Map<String, Integer> paramsForVelocity;
    Map<String, Integer> paramsForCurrent;
    final Lock lock = new ReentrantLock();
    final Condition enablingCompleted = this.lock.newCondition();
    protected volatile boolean enabling = false;

    public CanOpenEPOS(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming, EposMode aMode, int currentValue) {
        super(aName, aTickMillis, nodeID, serialNB);
        this.mode = aMode;
        this.paramsForCurrent = paramsForCurrent;
        this.paramsForProfilePosition = paramsForProfilePosition;
        this.paramsForHoming = paramsForHoming;
        this.currentValue = currentValue;
        this.readCurrentValue = 0;
        this.readActualPosition = 0;
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public boolean isOff() {
        return !this.on;
    }

    @Override
    public int getReadValue() {
        return this.readValue;
    }

    @Override
    public int getSentValue() {
        return this.sentValue;
    }

    @Override
    public int getSentCurrentMinValue() {
        return 0;
    }

    @Override
    public int getSentCurrentMaxValue() {
        return 3000;
    }

    public int getMotorParameterValue(String parameterName) throws EPOSConfigurationException {
        if (this.paramsForCurrent.containsKey(parameterName)) {
            return this.paramsForCurrent.get(parameterName);
        }
        throw new EPOSConfigurationException(String.valueOf(parameterName) + " :undefined", this.getName());
    }

    public String printParameters(String modeInString) {
        EposMode aMode = EposMode.valueOf(modeInString.trim().toUpperCase());
        Map<String, Integer> paramsMap = null;
        switch (aMode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case PROFILE_VELOCITY: {
                paramsMap = this.paramsForProfileVelocity;
                break;
            }
            case POSITION: {
                paramsMap = this.paramsForPosition;
                break;
            }
            case VELOCITY: {
                paramsMap = this.paramsForVelocity;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
            }
        }
        return this.printParameters(paramsMap);
    }

    public String printParameters(Map<String, Integer> paramMap) {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("Parameters in this map in configuration file:\n");
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            sb.append("key=");
            sb.append(paramName);
            sb.append("/value=");
            sb.append(value);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String readMode() throws SDORequestException {
        EposMode readMode;
        String modeInHexa;
        try {
            modeInHexa = this.readSDO("6061", "0").trim().toUpperCase();
        }
        catch (SDORequestException ex) {
            throw ex;
        }
        catch (ShortResponseToSDORequestException ex) {
            throw new SDORequestException(ex.getMessage());
        }
        this.mode = readMode = EposMode.getMode(modeInHexa);
        return readMode.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change EPOS mode .")
    public String changeMode(String modeInString) throws SDORequestException {
        EposMode newMode = EposMode.valueOf(modeInString.trim().toUpperCase());
        return this.changeMode(newMode);
    }

    @Override
    public String changeMode(EposMode newMode) throws SDORequestException {
        this.writeSDO("6060", "0", "1", newMode.modeInHexa);
        this.mode = newMode;
        return String.valueOf(this.getName()) + " mode has been changed to: " + newMode.toString() + ". Please check parameters associated with this mode.";
    }

    public static String displayListParameters(String modeInString) {
        Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters for mode: ");
        sb.append(modeInString);
        sb.append("\n");
        Parameter[] parameterArray = params = EposMode.valueOf(modeInString).parameters;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            sb.append(param.display());
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    public static String displayListParameters() {
        Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters : ");
        sb.append("\n");
        Parameter[] parameterArray = params = Parameter.values();
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            sb.append(param.display());
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    public String readParameters(String modeInString) throws SDORequestException {
        Parameter[] params;
        StringBuilder sb = new StringBuilder("Value set for the parameters for the mode : ");
        sb.append(modeInString);
        sb.append("\n");
        Parameter[] parameterArray = params = EposMode.valueOf(modeInString).parameters;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            try {
                String valueInHexa = this.readSDO(param.index, param.subindex);
                int valueInt = Integer.parseInt(valueInHexa, 16);
                sb.append(param.toString());
                sb.append("=");
                sb.append(valueInt);
                sb.append("\n");
            }
            catch (ShortResponseToSDORequestException ex) {
                throw new SDORequestException(String.valueOf(this.name) + ex.getMessage());
            }
            ++n2;
        }
        return sb.toString();
    }

    public String readParameters() throws SDORequestException {
        String modeInString = this.readMode();
        return this.readParameters(modeInString);
    }

    public void writeParameters(String modeInString) throws SDORequestException, ErrorInCommandExecutionException {
        EposMode aMode = EposMode.valueOf(modeInString);
        this.writeParameters(aMode);
    }

    @Override
    public void writeParameters(EposMode mode) throws SDORequestException, ErrorInCommandExecutionException {
        String modeInString = mode.toString();
        Map<String, Integer> paramsMap = null;
        switch (mode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case PROFILE_VELOCITY: {
                paramsMap = this.paramsForProfileVelocity;
                break;
            }
            case POSITION: {
                paramsMap = this.paramsForPosition;
                break;
            }
            case VELOCITY: {
                paramsMap = this.paramsForVelocity;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
            }
        }
        if (paramsMap == null) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "parameters for mode :" + modeInString + "are NULL");
        }
        if (paramsMap.isEmpty()) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "parameters for mode :" + modeInString + "are not defined.");
        }
        this.writeParameters(paramsMap);
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) throws SDORequestException {
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            this.writeParameter(paramName, value);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Set EPOS parameter with the value given as argument.")
    public String writeParameter(String parameterName, int value) throws SDORequestException {
        Parameter param = Parameter.valueOf(parameterName);
        return this.writeParameter(param, value);
    }

    public String writeParameter(Parameter param, int value) throws SDORequestException {
        this.writeSDO(param.index, param.subindex, param.size, Integer.toHexString(value));
        return String.format("%s has been written to the CanEpos CPU, value=%d", param.toString(), value);
    }

    public int readParameter(String parameterName) throws SDORequestException, ShortResponseToSDORequestException {
        Parameter param = Parameter.valueOf(parameterName);
        return this.readParameter(param);
    }

    public int readParameter(Parameter param) throws SDORequestException, ShortResponseToSDORequestException {
        String valueInHexa = this.readSDO(param.index, param.subindex);
        return new BigInteger(valueInHexa, 16).intValue();
    }

    @Override
    public boolean isTargetPositionReached(int position) throws SDORequestException {
        int myPosition = 0;
        myPosition = this.readPosition();
        return myPosition == position;
    }

    public void updateReadValue() throws BadCommandException, SDORequestException {
        if (this.mode.equals((Object)EposMode.VELOCITY)) {
            this.readValue = this.readVelocity();
        } else if (this.mode.equals((Object)EposMode.CURRENT)) {
            this.readValue = this.readCurrent();
        }
    }

    @Override
    public void initModule() {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
    }

    @Override
    public String initializeHardware() throws Exception {
        this.initialized = true;
        return String.valueOf(this.getName()) + ": no hardware initialization for this device to be done.";
    }

    /*
     * Exception decompiling
     */
    public boolean isEnable() throws SDORequestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void faultReset() throws SDORequestException {
        this.writeControlWord("80");
    }

    @Override
    public String enable() throws SDORequestException {
        this.lock.lock();
        try {
            this.enabling = true;
            this.shutdown();
            this.switchOnEnableOperation();
            String string = String.valueOf(this.getName()) + " ENABLE";
            return string;
        }
        finally {
            this.enabling = false;
            this.enablingCompleted.signal();
            this.lock.unlock();
        }
    }

    public String shutdown() throws SDORequestException {
        this.writeControlWord("6");
        return String.valueOf(this.getName()) + " DISABLE";
    }

    public void switchOnEnableOperation() throws SDORequestException {
        this.writeControlWord("F");
    }

    public Object saveParameters() throws SDORequestException {
        return this.writeSDO("1010", "1", "4", "65766173");
    }

    public Object restoreParameters() throws SDORequestException {
        return this.writeSDO("1011", "1", "4", "64616F6C");
    }

    public void writeControlWord(String value) throws SDORequestException {
        this.writeSDO("6040", "0", "2", value);
    }

    public String readControlWord() throws SDORequestException {
        try {
            return this.readSDO("6040", "0");
        }
        catch (ShortResponseToSDORequestException ex) {
            throw new SDORequestException(String.valueOf(this.name) + ex.getMessage());
        }
    }

    public String readStatusWord() throws SDORequestException {
        try {
            return this.readSDO("6041", "0");
        }
        catch (ShortResponseToSDORequestException ex) {
            throw new SDORequestException(String.valueOf(this.name) + ex.getMessage());
        }
    }

    public void quickStop() throws SDORequestException {
        switch (this.mode) {
            case HOMING: {
                this.writeControlWord("B");
                break;
            }
            case PROFILE_POSITION: {
                this.writeControlWord("B");
                break;
            }
            case PROFILE_VELOCITY: {
                break;
            }
            case POSITION: {
                break;
            }
            case VELOCITY: {
                this.writeControlWord("B");
                break;
            }
            case CURRENT: {
                this.writeControlWord("2");
            }
        }
    }

    public String onOld() throws BadCommandException, EPOSConfigurationException, ErrorInCommandExecutionException {
        try {
            this.enable();
            if (!this.isEnable()) {
                throw new BadCommandException("Actuator has to be enable prior ON command.");
            }
            if (this.mode.equals((Object)EposMode.VELOCITY)) {
                this.setVelocity();
            } else if (this.mode.equals((Object)EposMode.CURRENT)) {
                if (this.currentValue == 0) {
                    throw new BadCommandException("A current value has to be set");
                }
                this.writeCurrent(this.currentValue);
            }
            this.on = true;
            this.sentValue = this.currentValue;
            this.updateReadValue();
            return String.valueOf(this.getName()) + " ON";
        }
        catch (SDORequestException ex) {
            fcslog.error((Object)(String.valueOf(this.getName()) + " Can Open ERROR in sending the command ON."), new String[0]);
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": Error in command ON" + ex.toString());
        }
    }

    @Override
    public String on() throws SDORequestException, BadCommandException, ErrorInCommandExecutionException {
        this.enable();
        if (!this.isEnable()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " Controller couln'd be enabled in ON command.");
        }
        switch (this.mode) {
            case HOMING: {
                this.writeControlWord("1F");
                break;
            }
            case PROFILE_POSITION: {
                this.writeControlWord("3F");
                break;
            }
            case PROFILE_VELOCITY: {
                break;
            }
            case POSITION: {
                break;
            }
            case VELOCITY: {
                this.setVelocity();
                break;
            }
            case CURRENT: {
                if (this.currentValue == 0) {
                    throw new BadCommandException("A current value has to be set");
                }
                this.writeCurrent(this.currentValue);
                this.sentValue = this.currentValue;
            }
        }
        this.on = true;
        this.updateReadValue();
        return String.valueOf(this.getName()) + " ON";
    }

    public String offOld() throws BadCommandException, ErrorInCommandExecutionException {
        try {
            if (this.mode.equals((Object)EposMode.VELOCITY)) {
                this.stopVelocity();
                this.shutdown();
            } else if (this.mode.equals((Object)EposMode.CURRENT)) {
                this.stopCurrent();
                this.shutdown();
            }
            this.on = false;
            this.sentValue = 0;
            this.updateReadValue();
            return String.valueOf(this.getName()) + " OFF";
        }
        catch (SDORequestException ex) {
            fcslog.error((Object)ex.getMessage(), new String[0]);
            throw new ErrorInCommandExecutionException((Object)((Object)ex) + "Error in reading SDO request");
        }
    }

    @Override
    public String off() throws BadCommandException, SDORequestException {
        switch (this.mode) {
            case HOMING: {
                this.writeControlWord("11F");
                break;
            }
            case PROFILE_POSITION: {
                this.writeControlWord("10F");
                break;
            }
            case PROFILE_VELOCITY: {
                break;
            }
            case POSITION: {
                break;
            }
            case VELOCITY: {
                this.stopVelocity();
                break;
            }
            case CURRENT: {
                this.stopCurrent();
            }
        }
        this.shutdown();
        this.on = false;
        this.sentValue = 0;
        this.updateReadValue();
        fcslog.info((Object)(String.valueOf(this.name) + " is TURNED OFF"), new String[0]);
        return String.valueOf(this.name) + " OFF";
    }

    @Override
    public boolean checkMotorParameters() throws EPOSConfigurationException, SDORequestException, ShortResponseToSDORequestException {
        int readPolePairNumber;
        int readOutputCurrentLimit;
        int readThermalTimeConstantWinding;
        int readMaxSpeedInCurrentMode;
        int readContinuousCurrentLimit;
        int readPositionSensorType;
        boolean ok = true;
        int readMotorType = this.readParameter(Parameter.MotorType);
        if (readMotorType != this.getMotorParameterValue("MotorType")) {
            ok = false;
        }
        if ((readPositionSensorType = this.readParameter(Parameter.PositionSensorType)) != this.getMotorParameterValue("PositionSensorType")) {
            ok = false;
        }
        if ((readContinuousCurrentLimit = this.readParameter(Parameter.ContinuousCurrentLimit)) != this.getMotorParameterValue("ContinuousCurrentLimit")) {
            ok = false;
        }
        if ((readMaxSpeedInCurrentMode = this.readParameter(Parameter.MaxSpeedInCurrentMode)) != this.getMotorParameterValue("MaxSpeedInCurrentMode")) {
            ok = false;
        }
        if ((readThermalTimeConstantWinding = this.readParameter(Parameter.ThermalTimeConstantWinding)) != this.getMotorParameterValue("ThermalTimeConstantWinding")) {
            ok = false;
        }
        if ((readOutputCurrentLimit = this.readParameter(Parameter.OutputCurrentLimit)) != this.getMotorParameterValue("OutputCurrentLimit")) {
            ok = false;
        }
        if ((readPolePairNumber = this.readParameter(Parameter.PolePairNumber)) != this.getMotorParameterValue("PolePairNumber")) {
            ok = false;
        }
        if (!ok) {
            throw new EPOSConfigurationException("ERROR in hardware configuration of the motor", this.name, readMotorType, readContinuousCurrentLimit, readMaxSpeedInCurrentMode, readThermalTimeConstantWinding, readOutputCurrentLimit, readPolePairNumber);
        }
        return ok;
    }

    public String displayMotorParameters() throws SDORequestException, ShortResponseToSDORequestException {
        StringBuilder sb = new StringBuilder("Read decimal values for motor parameters are :");
        int readMotorType = this.readParameter(Parameter.MotorType);
        int readPositionSensorType = this.readParameter(Parameter.PositionSensorType);
        int readContinuousCurrentLimit = this.readParameter(Parameter.ContinuousCurrentLimit);
        int readMaxSpeedInCurrentMode = this.readParameter(Parameter.MaxSpeedInCurrentMode);
        int readThermalTimeConstantWinding = this.readParameter(Parameter.ThermalTimeConstantWinding);
        int readOutputCurrentLimit = this.readParameter(Parameter.OutputCurrentLimit);
        int readPolePairNumber = this.readParameter(Parameter.PolePairNumber);
        sb.append(" motor type =");
        sb.append(readMotorType);
        sb.append(" position sensor type =");
        sb.append(readPositionSensorType);
        sb.append(" continuousCurrentLimit =");
        sb.append(readContinuousCurrentLimit);
        sb.append(" maxSpeedInCurrentMode =");
        sb.append(readMaxSpeedInCurrentMode);
        sb.append(" thermalTimeConstantWinding =");
        sb.append(readThermalTimeConstantWinding);
        sb.append(" outputCurrentLimit =");
        sb.append(readOutputCurrentLimit);
        sb.append(" polePairNumber =");
        sb.append(readPolePairNumber);
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Set the current value in the EPOS CPU.")
    public void writeCurrent(int aValue) throws BadCommandException, SDORequestException {
        if (!this.isEnable()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not ENABLE");
        }
        if (!this.mode.equals((Object)EposMode.CURRENT)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in CURRENT mode");
        }
        try {
            if (aValue > this.getMotorParameterValue("ContinuousCurrentLimit")) {
                throw new IllegalArgumentException(String.valueOf(aValue) + " is greater than Continuous Current Limit");
            }
        }
        catch (EPOSConfigurationException ex) {
            fcslog.error((Object)(String.valueOf(this.getName()) + " ERROR in command writeCurrent:" + ex.toString()), new String[0]);
            throw new BadCommandException(String.valueOf(this.getName()) + ": ContinuousCurrentLimit is not defined");
        }
        this.currentValue = aValue;
        String currentValueInHexa = Integer.toHexString(aValue);
        this.writeSDO("2030", "0", "2", currentValueInHexa);
    }

    @Override
    public int readCurrent() throws BadCommandException, SDORequestException {
        try {
            String currentInHexa = this.readSDO("6078", "0");
            int uns16 = Integer.parseInt(currentInHexa, 16);
            fcslog.debug((Object)(String.valueOf(this.name) + ":readCurrent=" + CanOpenEPOS.convertToInteger16(uns16) + " Unsigned value read=" + uns16), new String[0]);
            this.readCurrentValue = CanOpenEPOS.convertToInteger16(uns16);
        }
        catch (ShortResponseToSDORequestException ex) {
            log.warning((Object)(String.valueOf(this.name) + "=> ERROR IN READING SENSOR:" + ex.getMessage()), new String[0]);
        }
        return this.readCurrentValue;
    }

    public void stopCurrent() throws BadCommandException, SDORequestException {
        if (!this.mode.equals((Object)EposMode.CURRENT)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in CURRENT mode");
        }
        this.writeSDO("2030", "00", "2", "0");
    }

    public void setVelocity() throws BadCommandException {
        if (!this.mode.equals((Object)EposMode.VELOCITY)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY mode");
        }
    }

    public int readVelocity() throws BadCommandException {
        if (this.mode.equals((Object)EposMode.VELOCITY)) {
            return 0;
        }
        throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY mode");
    }

    public void stopVelocity() throws BadCommandException, SDORequestException {
        if (!this.mode.equals((Object)EposMode.VELOCITY)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY mode");
        }
        this.writeSDO("206B", "00", "2", "0");
    }

    public int readPositionActualValue() throws SDORequestException {
        try {
            this.readActualPosition = this.readParameter(Parameter.PositionActualValue);
        }
        catch (ShortResponseToSDORequestException ex) {
            log.warning((Object)(String.valueOf(this.name) + "=> ERROR IN READING SENSOR:" + ex.getMessage()), new String[0]);
        }
        return this.readActualPosition;
    }

    public String setHomingMethodActual() throws SDORequestException, BadCommandException {
        if (!this.mode.equals((Object)EposMode.HOMING)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in HOMING mode");
        }
        return this.writeParameter(Parameter.HomingMethod, 35);
    }

    public void startHoming() throws SDORequestException, BadCommandException, ErrorInCommandExecutionException {
        if (!this.mode.equals((Object)EposMode.HOMING)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in HOMING mode");
        }
        this.on();
    }

    public String setHomePosition(int position) throws SDORequestException, BadCommandException {
        if (!this.mode.equals((Object)EposMode.HOMING)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in HOMING mode");
        }
        return this.writeParameter(Parameter.HomePosition, position);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    public void defineAbsolutePosition(int position) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        fcslog.debug((Object)this.name, new String[]{"Defining Absolute Position:" + position});
        this.changeMode(EposMode.HOMING);
        this.writeParameters(EposMode.HOMING);
        if (!this.isEnable()) {
            this.enable();
        }
        this.setHomePosition(position);
        this.setHomingMethodActual();
        this.on();
    }

    @Override
    public void writeTargetPosition(int aValue) throws BadCommandException, SDORequestException {
        if (!this.mode.equals((Object)EposMode.PROFILE_POSITION)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in PROFILE_POSITION mode");
        }
        if (!this.isEnable()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not ENABLE");
        }
        String targetPositionInHexa = Integer.toHexString(aValue);
        this.targetPosition = aValue;
        this.writeSDO("607A", "0", "4", targetPositionInHexa);
    }

    @Override
    public int readPosition() throws SDORequestException {
        return this.readPositionActualValue();
    }

    public void activateCurrentMode() throws SDORequestException {
        this.changeMode(EposMode.CURRENT);
        this.writeParameters(this.paramsForCurrent);
    }

    public void activateHomingMode() throws SDORequestException {
        this.changeMode(EposMode.HOMING);
        this.writeParameters(this.paramsForHoming);
    }

    public void activateProfilePositionMode() throws SDORequestException {
        this.changeMode(EposMode.PROFILE_POSITION);
        this.writeParameters(this.paramsForProfilePosition);
    }

    public static int convertToInteger16(int unsigned16) {
        if (unsigned16 < 32768) {
            return unsigned16;
        }
        return unsigned16 - 65535;
    }

    public static void main(String[] args) {
        System.out.println(CanOpenEPOS.displayListParameters("HOMING"));
        System.out.println(CanOpenEPOS.displayListParameters("CURRENT"));
        System.out.println(CanOpenEPOS.displayListParameters("PROFILE_POSITION"));
        System.out.println(CanOpenEPOS.displayListParameters());
    }

    public static enum EposMode {
        HOMING("6", Parameter.MaxFollowingError, Parameter.HomeOffset, Parameter.MaxProfileVelocity, Parameter.QuickStopDeceleration, Parameter.SpeedForSwitchSearch, Parameter.SpeedForZeroSearch, Parameter.HomingAcceleration, Parameter.CurrentThresholdHomingMode, Parameter.HomePosition),
        PROFILE_POSITION("1", Parameter.MaxFollowingError, Parameter.MinPositionLimit, Parameter.MaxPositionLimit, Parameter.MaxProfileVelocity, Parameter.ProfileVelocity, Parameter.ProfileAcceleration, Parameter.ProfileDeceleration, Parameter.QuickStopDeceleration, Parameter.MotionProfileType),
        PROFILE_VELOCITY("3", new Parameter[0]),
        POSITION("FF", new Parameter[0]),
        VELOCITY("FE", new Parameter[0]),
        CURRENT("FD", Parameter.ContinuousCurrentLimit, Parameter.OutputCurrentLimit, Parameter.MaxSpeedInCurrentMode, Parameter.PolePairNumber, Parameter.ThermalTimeConstantWinding, Parameter.MotorType, Parameter.PositionSensorType);

        private final String modeInHexa;
        private final Parameter[] parameters;

        private EposMode(String modeToHexa, Parameter ... params) {
            this.modeInHexa = modeToHexa;
            this.parameters = params;
        }

        String getModeInHexa() {
            return this.modeInHexa;
        }

        public static EposMode getMode(String hexa) {
            EposMode[] modes = EposMode.values();
            boolean modeFound = false;
            EposMode[] eposModeArray = modes;
            int n = modes.length;
            int n2 = 0;
            while (n2 < n) {
                EposMode mode = eposModeArray[n2];
                if (mode.getModeInHexa().equals(hexa.toUpperCase())) {
                    modeFound = true;
                    return mode;
                }
                ++n2;
            }
            if (!modeFound) {
                throw new IllegalArgumentException(String.valueOf(hexa) + ": this mode doesn't exist in CanOpenEpos.EposMode ENUM");
            }
            return null;
        }
    }

    public static enum Parameter {
        MaxFollowingError("6065", "00", "2", false),
        HomeOffset("607C", "00", "4", true),
        MaxProfileVelocity("607F", "00", "2", false),
        SpeedForSwitchSearch("6099", "01", "2", false),
        SpeedForZeroSearch("6099", "02", "2", false),
        HomingAcceleration("609A", "00", "2", false),
        CurrentThresholdHomingMode("2080", "00", "1", false),
        HomePosition("2081", "00", "4", false),
        HomingMethod("6098", "00", "1", true),
        MinPositionLimit("607D", "01", "4", true),
        MaxPositionLimit("607D", "02", "4", true),
        PositionActualValue("6064", "00", "4", true),
        ProfileVelocity("6081", "00", "4", false),
        ProfileAcceleration("6083", "00", "4", false),
        ProfileDeceleration("6084", "00", "4", false),
        QuickStopDeceleration("6085", "00", "4", false),
        MotionProfileType("6086", "00", "2", false),
        MotorType("6402", "00", "2", false),
        ContinuousCurrentLimit("6410", "01", "2", false),
        OutputCurrentLimit("6410", "02", "2", false),
        PolePairNumber("6410", "03", "1", false),
        MaxSpeedInCurrentMode("6410", "04", "4", false),
        ThermalTimeConstantWinding("6410", "05", "2", false),
        PositionSensorType("2210", "02", "2", false);

        String index;
        String subindex;
        String size;
        boolean signed;

        private Parameter(String index, String subindex, String size, boolean signed) {
            this.index = index;
            this.subindex = subindex;
            this.size = size;
            this.signed = signed;
        }

        public String display() {
            StringBuilder sb = new StringBuilder(this.toString());
            sb.append("/index=").append(this.index);
            sb.append("/subindex=").append(this.subindex);
            sb.append("/size=").append(this.size).append(" bytes");
            if (this.signed) {
                sb.append("/SIGNED");
            } else {
                sb.append("/UNSIGNED");
            }
            return sb.toString();
        }
    }
}

