/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.FcsTcpProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenDIO
extends CompactIOModule
implements PieceOfHardware {
    CanOpenProxy tcpProxy;
    String serialNB;
    String nodeID;
    boolean initialized;

    public CanOpenDIO() {
    }

    public CanOpenDIO(String nodeID, String serial) {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
        this.serialNB = serial;
        this.nodeID = nodeID;
        this.initialized = false;
    }

    @Override
    public void initModule() {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
    }

    @Override
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    public void setSerialNB(String serialNB) {
        this.serialNB = serialNB;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    public boolean isInitalized() {
        return this.initialized;
    }

    @Override
    public boolean isNodeIdBootedAndOK() {
        return this.tcpProxy.isNodeIdBootedAndOK(this);
    }

    public String writeDigitalOutput(int outputNB, int value) throws SDORequestException, HardwareNotDetectedException {
        if (!this.tcpProxy.isHardwareReady()) {
            String message = String.format("DAC %s / nodeID=%s is NOT BOOTED", this.getName(), this.nodeID);
            FcsTcpProxy.fcslog.error((Object)message, new String[0]);
            throw new HardwareNotDetectedException("a CanOpenDIO is missing", this.getName(), this.nodeID, this.serialNB);
        }
        if (outputNB < 1 || outputNB > 8) {
            throw new IllegalArgumentException("CAN-CBX-DIO8 : input has to be 1..8");
        }
        String valueInHexa = Integer.toHexString(value);
        String inputNBInHexa = Integer.toHexString(outputNB);
        return this.tcpProxy.writeSDO(this.nodeID, "6200", inputNBInHexa, "2", valueInHexa);
    }

    @Override
    public String readNewHexaValue() {
        try {
            this.hexaValue = this.tcpProxy.readSDO(this.nodeID, "6000", "1");
        }
        catch (SDORequestException ex) {
            String mes = String.valueOf(this.name) + ": ERROR IN READING SENSOR:";
            FcsTcpProxy.fcslog.error((Object)(String.valueOf(mes) + ex.getMessage()), new String[0]);
        }
        catch (ShortResponseToSDORequestException ex) {
            String mes = String.valueOf(this.name) + ": GOT A STRANGE RESPONSE IN READING SENSOR:";
            FcsTcpProxy.fcslog.warning((Object)(String.valueOf(mes) + ex.getMessage()), new String[0]);
        }
        return this.hexaValue;
    }

    public String writeMask() throws SDORequestException {
        return this.tcpProxy.writeSDO(this.nodeID, "2250", "1", "1", "3");
    }

    public boolean checkMask() throws SDORequestException, ShortResponseToSDORequestException {
        String maskValue = this.tcpProxy.readSDO(this.nodeID, "6000", "1");
        return maskValue.equals("3");
    }

    @Override
    public int readNewValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String initializeHardware() throws Exception {
        this.initialized = true;
        return String.valueOf(this.getName()) + ": no hardware initialization for this device to be done.";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/");
        sb.append(this.serialNB);
        sb.append("/NodeID_in_hexa=");
        sb.append(this.nodeID);
        int x = Integer.parseInt(this.nodeID, 16);
        sb.append("/NodeID_in_decimal=");
        sb.append(x);
        sb.append("/");
        if (this.tcpProxy == null) {
            return sb.toString();
        }
        if (this.isNodeIdBootedAndOK()) {
            sb.append("is booted/");
        } else {
            sb.append("ERROR/");
        }
        return sb.toString();
    }
}

