/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class BridgeToCanOpenHardware
extends Module
implements BridgeToHardware {
    protected static final Logger fcslog = FcsUtils.log;
    protected CanOpenProxy tcpProxy;
    protected boolean configurationChecked = false;
    protected boolean hardwareInitialized = false;
    protected Map<String, PieceOfHardware> hardwareMap;

    public BridgeToCanOpenHardware(String aName, int aTickMillis, CanOpenProxy tcpProxy) {
        super(aName, aTickMillis);
        this.tcpProxy = tcpProxy;
    }

    public PieceOfHardware[] listHardware() {
        Map children = this.getChildren(PieceOfHardware.class);
        PieceOfHardware[] list = new PieceOfHardware[children.size()];
        int i = 0;
        for (Map.Entry entry : children.entrySet()) {
            String key = (String)entry.getKey();
            fcslog.debug((Object)("key=" + key), new String[0]);
            PieceOfHardware device = (PieceOfHardware)entry.getValue();
            fcslog.debug((Object)("hardware=" + device.getName() + "#" + device.toString()), new String[0]);
            list[i] = device;
            ++i;
        }
        return list;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print my children; for tests")
    public void printChildren() {
        Map children = this.getChildren(PieceOfHardware.class);
        for (Map.Entry entry : children.entrySet()) {
            String key = (String)entry.getKey();
            fcslog.debug((Object)("key=" + key), new String[0]);
            PieceOfHardware device = (PieceOfHardware)entry.getValue();
            fcslog.debug((Object)("hardware=" + device.getName() + "#" + device.toString()), new String[0]);
        }
    }

    @Override
    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    @Override
    public void startServer() {
        this.tcpProxy.startServer();
    }

    @Override
    public void startThreadReader() {
        this.tcpProxy.startThreadReader();
    }

    @Override
    public boolean isCWrapperConnected() {
        return this.tcpProxy.isReady(this.tcpProxy.getMyClientName());
    }

    @Override
    public boolean isHardwareReady() {
        return this.tcpProxy.isHardwareReady();
    }

    @Override
    public boolean isRealHardware() {
        return true;
    }

    public void initModule() {
        fcslog.info((Object)(String.valueOf(this.name) + ":INIT MODULE BRIDGE TO REAL HARDWARE: " + this.name), new String[0]);
        this.hardwareMap = this.getChildren(PieceOfHardware.class);
        PieceOfHardware[] hardwareList = this.listHardware();
        this.tcpProxy.hardwareList = hardwareList;
        int numberOfNodes = hardwareList.length;
        this.tcpProxy.setExpectedNodesNB(numberOfNodes);
        fcslog.info((Object)(String.valueOf(this.name) + ":NUMBER OF CAN OPEN DEVICES EXPECTED =" + numberOfNodes), new String[0]);
        fcslog.info((Object)this.toString(), new String[0]);
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        }
        catch (DeploymentException ex) {
            fcslog.error((Object)(String.valueOf(ex.getMessage()) + ": Could not load CanOpen Error Tables"), new String[0]);
            this.getSubsystem().raiseAlarm("Could not load CanOpen Error Tables" + ex.toString());
        }
    }

    @Deprecated
    public void checkMatos() throws HardwareNotDetectedException, HardwareConfigurationException {
        int bootedHardwareNb = this.hardwareMap.entrySet().size();
        fcslog.info((Object)this.name, new String[]{"number of pieces of hardware expected=" + bootedHardwareNb});
        Map<String, CanOpenNode> bootedNodesMap = this.tcpProxy.bootedNodesMap;
        fcslog.info((Object)this.name, new String[]{"number of pieces of hardware booted=" + bootedNodesMap.entrySet().size()});
        for (Map.Entry<String, PieceOfHardware> entry : this.hardwareMap.entrySet()) {
            entry.getKey();
            PieceOfHardware device = entry.getValue();
            fcslog.debug((Object)("Checking hardware=" + device.getName() + "#" + device.toString()), new String[0]);
            String serial = device.getSerialNB();
            String nodeID = device.getNodeID();
            if (bootedNodesMap.containsKey(nodeID)) {
                CanOpenNode bootedNode = bootedNodesMap.get(nodeID);
                if (bootedNode.getSerialNB().equalsIgnoreCase(serial)) {
                    fcslog.info((Object)("booted hardware=" + device.getName() + ":" + device.toString()), new String[0]);
                    continue;
                }
                fcslog.error((Object)("hardware with nodeID" + nodeID + "is booted but with an unexpected serial number."), new String[0]);
                fcslog.error((Object)("hardware in error:" + device.toString()), new String[0]);
                fcslog.error((Object)("serial number found for this nodeID:" + bootedNode.getSerialNB()), new String[0]);
                throw new HardwareConfigurationException("Unexpected serial number", device.getName());
            }
            throw new HardwareNotDetectedException("Hardware is not booted:", device.getName(), device.getNodeID(), device.getSerialNB());
        }
    }

    public Object sendCanOpen(String command) throws InterruptedException, CanOpenCallTimeoutException, BadCommandException {
        return this.tcpProxy.sendCanOpen(command);
    }

    @Override
    public CanOpenProxy.PDOStorage readPDOs() throws FcsHardwareException, BadCommandException {
        fcslog.debug((Object)(String.valueOf(this.name) + "/readPDOS"), new String[0]);
        return this.tcpProxy.readPDOs();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/hardware list={");
        PieceOfHardware[] pieceOfHardwareArray = this.listHardware();
        int n = pieceOfHardwareArray.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware p = pieceOfHardwareArray[n2];
            sb.append(" ");
            sb.append(p.toString());
            sb.append(";");
            ++n2;
        }
        sb.append("}");
        return sb.toString();
    }
}

