/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.atomic.AtomicBoolean;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.utilities.tracers.Tracer;

public abstract class MainModule
extends Module {
    protected BridgeToHardware bridge;
    protected boolean hardwareReady = false;
    protected AtomicBoolean haltRequired;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !MainModule.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version((String)"$Rev$", MainModule.class, (String)"org-lsst-ccs-subsystems-fcs")) {
            throw new AssertionError();
        }
    }

    public MainModule(String aName, int aTickMillis, BridgeToHardware bridge) {
        super(aName, aTickMillis);
        this.bridge = bridge;
    }

    public void initModule() {
        this.haltRequired = new AtomicBoolean(false);
    }

    @Command(level=1, description="Return true if hardware is booted, identified and initialized.", type=Command.CommandType.QUERY)
    public boolean isHardwareReady() {
        if (this.hardwareReady) {
            return this.hardwareReady;
        }
        this.hardwareReady = this.bridge.isHardwareReady();
        return this.hardwareReady;
    }

    @Command(type=Command.CommandType.QUERY, description="Return true if this main module controls real hardware.")
    public boolean controlRealHardware() {
        return this.bridge.isRealHardware();
    }

    @Command(level=1, description="Return the list of can open hardware that this subsystem manage.", type=Command.CommandType.QUERY)
    public String listHardware() {
        return this.bridge.getTcpProxy().listHardware();
    }

    public String toString() {
        return super.toString();
    }
}

