/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class LoaderModule
extends Module {
    private static final Logger fcslog = FcsUtils.log;
    private final LoaderCarrierModule carrier;
    private final LoaderClampModule clamp;
    private AutoChangerModule autochanger;
    private NumericSensor filterPresenceSensor;
    private NumericSensor loaderOnCameraPresenceSensor;
    private NumericSensor autochangerPresenceSensor;
    private final String plutoGatewayName;
    private PlutoGatewayModule plutoGateway;
    private boolean empty;
    private boolean connectedOnCamera;
    private boolean autochangerHoldingFilter;
    private final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private volatile boolean updatingState = false;

    public LoaderModule(String moduleName, int aTickMillis, LoaderCarrierModule carrier, LoaderClampModule clamp, String plutoGatewayName, NumericSensor filterPresenceSensor, NumericSensor loaderOnCameraPresenceSensor) {
        super(moduleName, aTickMillis);
        this.carrier = carrier;
        this.clamp = clamp;
        this.plutoGatewayName = plutoGatewayName;
        this.empty = false;
        this.connectedOnCamera = false;
        this.autochangerHoldingFilter = false;
    }

    public void initModule() {
        this.autochanger = (AutoChangerModule)this.getModule("autochanger");
        this.plutoGateway = (PlutoGatewayModule)this.getModule(this.plutoGatewayName);
        this.filterPresenceSensor = (NumericSensor)this.getModule("filterPresenceSensor");
        this.loaderOnCameraPresenceSensor = (NumericSensor)this.getModule("loaderOnCameraPresenceSensor");
        this.autochangerPresenceSensor = (NumericSensor)this.getModule("autochangerPresenceSensor");
    }

    public boolean isHardwareReady() {
        BridgeToHardware bridgeToLoader = (BridgeToHardware)this.getModule("bridge");
        return bridgeToLoader.isHardwareReady();
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the loader. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected on the camera. This command doesn't read again the sensors.")
    public boolean isConnectedOnCamera() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the autochanger is holding the filter. This command doesn't read again the sensors.")
    public boolean isAutochangerHoldingFilter() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a filter is there and it is held by the clamp.")
    public boolean isHoldingAFilter() throws SDORequestException, BadCommandException, FcsHardwareException {
        this.updateStateWithSensors();
        return !this.isEmpty() && this.clamp.isAtClampedPosition();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if no filter is in the loader.")
    public boolean isMoving() {
        return this.clamp.isMoving();
    }

    public LoaderClampModule getClamp() {
        return this.clamp;
    }

    public LoaderCarrierModule getCarrier() {
        return this.carrier;
    }

    public boolean isCarrierAtStoragePosition() {
        return this.carrier.isAtStoragePosition();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if loader is connected to the camera.")
    public boolean isOnCamera() throws FcsHardwareException {
        this.carrier.updateStateWithSensors();
        return this.carrier.isConnectedOnCamera();
    }

    public void initializeHardware() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.updateStateWithSensors();
        this.clamp.initializeHardware();
        this.carrier.initialiazeHardware();
    }

    public void tick() {
    }

    @Command(level=1, description="Return true if the carrier can move.", type=Command.CommandType.QUERY)
    public boolean checkPreConditionsForCarrierMotion() throws SDORequestException, BadCommandException, FcsHardwareException, ErrorInCommandExecutionException {
        fcslog.info((Object)(String.valueOf(this.name) + " checking pre-conditions for carrier motion"), new String[0]);
        this.updateStateWithSensors();
        return this.carrier.isEmpty() || this.isHoldingAFilter();
    }

    @Command(level=1, type=Command.CommandType.QUERY, description="Check if the clamp can be open.")
    public boolean checkPreConditionsForOpeningHooks() throws SDORequestException, BadCommandException, FcsHardwareException, ErrorInCommandExecutionException {
        fcslog.info((Object)(String.valueOf(this.name) + " checking pre-conditions for opening hooks"), new String[0]);
        this.updateStateWithSensors();
        return this.carrier.isEmpty() || this.isHoldingAFilter() && this.carrier.isAtHandoffPosition() && this.autochanger.isHoldingFilterAtHandoff();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close hooks.")
    public String closeHooks() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.clamp.close();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clamp hooks.")
    public String clampHooks() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.clamp.clamp();
    }

    @Command(level=1, type=Command.CommandType.ACTION, description="Open the hooks")
    public String openHooks() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.checkPreConditionsForOpeningHooks();
        return this.clamp.open();
    }

    @Command(level=1, description="Move the loader carrier to HANDOFF position", type=Command.CommandType.ACTION)
    public void moveToHandoff() throws BadCommandException, FcsHardwareException, SDORequestException, ErrorInCommandExecutionException {
        this.checkPreConditionsForCarrierMotion();
        this.carrier.goToHandOff();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the loader carrier to STORAGE position")
    public void moveToStorage() throws BadCommandException, FcsHardwareException, SDORequestException, ErrorInCommandExecutionException {
        this.checkPreConditionsForCarrierMotion();
        this.carrier.goToStorage();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.plutoGateway.updateValues();
            String[] readHexaValues = this.plutoGateway.getHexaValues();
            fcslog.finest((Object)("readHexaValues[0]=" + readHexaValues[0]), new String[0]);
            fcslog.finest((Object)("readHexaValues[1]=" + readHexaValues[1]), new String[0]);
            this.filterPresenceSensor.updateValue(readHexaValues);
            this.loaderOnCameraPresenceSensor.updateValue(readHexaValues);
            this.autochangerPresenceSensor.updateValue(readHexaValues);
            this.clamp.updateStateWithSensors(readHexaValues);
            this.empty = this.filterPresenceSensor.digitalValue == 0;
            this.connectedOnCamera = this.loaderOnCameraPresenceSensor.getDigitalValue() == 1;
            this.autochangerHoldingFilter = this.autochangerPresenceSensor.getDigitalValue() == 1;
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="List and display info on the hooks.")
    public String listHooks() {
        return this.clamp.listHooks();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display hooks sensors values.")
    public String listSensorsValues() {
        return this.clamp.listSensorsValues();
    }

    public void test() {
        CurrentCommandContext currentCmdContext = (CurrentCommandContext)Subsystem.LOCAL_EXECUTION_INFO.get();
        fcslog.debug((Object)("Command running:" + currentCmdContext.getCommandName()), new String[0]);
        fcslog.info((Object)("coming from:" + currentCmdContext.getCommandOriginator()), new String[0]);
        this.getSubsystem().interruptActionThread();
    }
}

