/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Map;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderHookModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class LoaderClampModule
extends MobileItemModule {
    private final LoaderHookModule hook1;
    private final LoaderHookModule hook2;
    private final LoaderHookModule hook3;
    private final LoaderHookModule hook4;
    private final String plutoGatewayName;
    private EPOSController hooksController;
    private LoaderCarrierModule carrier;
    private LoaderModule loader;
    FcsEnumerations.LockStatus lockStatus;
    long timeoutForClosingHooks;
    long timeoutForClampingHooks;
    long timeoutForOpeningHooks;
    long timeoutForGoingToHomePosition;
    private volatile boolean initialized;
    final Condition stateUpdated;
    protected volatile boolean updatingState;
    private int position;
    int minPosition;
    int maxPosition;
    int targetPositionToOpen;
    int targetPositionToClose;
    int targetPositionToClamp;
    int currentToClamp;
    int currentToGoHome;
    int readCurrent;
    Map<String, Integer> paramsForCurrentToGoHome;
    Map<String, Integer> paramsForCurrentToClamp;

    public LoaderClampModule(String moduleName, int aTickMillis, LoaderHookModule hook1, LoaderHookModule hook2, LoaderHookModule hook3, LoaderHookModule hook4, String plutoGWName, long timeoutForClosingHooks, long timeoutForClosingHooksStrongly, long timeoutForOpeningHooks, long timeoutForGoingToHomePosition, int targetPositionToOpen, int targetPositionToClose, int targetPositionToCloseStrongly, int currentToClose, int currentToGoHome, Map<String, Integer> paramsForCurrentToClamp, Map<String, Integer> paramsForCurrentToGoHomePosition, int minPosition, int maxPosition) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.hook1 = hook1;
        this.hook2 = hook2;
        this.hook3 = hook3;
        this.hook4 = hook4;
        this.plutoGatewayName = plutoGWName;
        this.initialized = false;
        this.timeoutForClosingHooks = timeoutForClosingHooks;
        this.timeoutForClampingHooks = timeoutForClosingHooksStrongly;
        this.timeoutForOpeningHooks = timeoutForOpeningHooks;
        this.timeoutForGoingToHomePosition = timeoutForGoingToHomePosition;
        this.targetPositionToOpen = targetPositionToOpen;
        this.targetPositionToClose = targetPositionToClose;
        this.targetPositionToClamp = targetPositionToCloseStrongly;
        this.currentToClamp = currentToClose;
        this.currentToGoHome = currentToGoHome;
        this.paramsForCurrentToClamp = paramsForCurrentToClamp;
        this.paramsForCurrentToGoHome = paramsForCurrentToGoHomePosition;
        this.minPosition = minPosition;
        this.maxPosition = maxPosition;
    }

    public LoaderHookModule getHook1() {
        return this.hook1;
    }

    public LoaderHookModule getHook2() {
        return this.hook2;
    }

    public LoaderHookModule getHook3() {
        return this.hook3;
    }

    public LoaderHookModule getHook4() {
        return this.hook4;
    }

    public int getPosition() {
        return this.position;
    }

    public int getMinPosition() {
        return this.minPosition;
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    public int getTargetPositionToOpen() {
        return this.targetPositionToOpen;
    }

    public int getTargetPositionToClose() {
        return this.targetPositionToClose;
    }

    public int getTargetPositionToClamp() {
        return this.targetPositionToClamp;
    }

    public int getCurrentToClose() {
        return this.currentToClamp;
    }

    public int getCurrentToGoHome() {
        return this.currentToGoHome;
    }

    public long getTimeoutForClosingHooks() {
        return this.timeoutForClosingHooks;
    }

    public long getTimeoutForClampingHooks() {
        return this.timeoutForClampingHooks;
    }

    public long getTimeoutForOpeningHooks() {
        return this.timeoutForOpeningHooks;
    }

    public long getTimeoutForGoingToHomePosition() {
        return this.timeoutForGoingToHomePosition;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.LockStatus getLockStatus() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED")
    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED")
    public boolean isUnlocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if loader is empty.")
    public boolean isEmpty() {
        return this.loader.isEmpty();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if loader hardware is connected and ready.")
    public boolean isHardwareReady() {
        return ((LoaderModule)this.getModule("loader")).isHardwareReady();
    }

    public void initModule() {
        this.hooksController = (EPOSController)this.getModule("hooksController");
        this.carrier = (LoaderCarrierModule)this.getModule("carrier");
        this.loader = (LoaderModule)this.getModule("loader");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is open and at home position")
    public boolean isAtHomePosition() throws SDORequestException, BadCommandException {
        this.updatePosition();
        return this.position == 0;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is closed and at clamped position")
    public boolean isAtClampedPosition() throws SDORequestException, BadCommandException {
        this.updatePosition();
        return this.position == this.targetPositionToClamp;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is at closed position.")
    public boolean isAtClosedPosition() throws SDORequestException, BadCommandException {
        this.updatePosition();
        return this.position == this.targetPositionToClose;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is at open position.")
    public boolean isAtOpenPosition() throws SDORequestException, BadCommandException {
        this.updatePosition();
        return this.position == this.targetPositionToOpen;
    }

    public void initializeHardware() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.updateStateWithSensors();
        if (this.isEmpty()) {
            this.goToHomePosition();
            this.initialized = true;
        } else {
            this.goToClampedPosition();
            this.initialized = true;
        }
    }

    public void tick() {
        if (this.initialized) {
            try {
                this.updateStateWithSensors();
            }
            catch (FcsHardwareException ex) {
                fcslog.error((Object)ex.getMessage(), new String[0]);
                this.getSubsystem().raiseAlarm(ex.getMessage());
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Go to clamped position to intialize hardware.")
    public String goToClampedPosition() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.updateStateWithSensors();
        if (!this.loader.isConnectedOnCamera()) {
            throw new BadCommandException(String.valueOf(this.name) + " Loader not connected - can't execute command goToClampedPosition.");
        }
        if (this.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.name) + "No filter in carrier -  can't execute command goToClampedPosition if carrier is empty.");
        }
        this.updatePosition();
        if (this.initialized && this.isAtClampedPosition()) {
            throw new BadCommandException(String.valueOf(this.name) + " is already at clamped position.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.GOTOCLAMPEDPOSITION, this.timeoutForClampingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Go to home position to intialize hardware.")
    public String goToHomePosition() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.updateStateWithSensors();
        if (!this.loader.isConnectedOnCamera()) {
            throw new BadCommandException(String.valueOf(this.name) + " Loader not connected - can't execute command goToHomePosition.");
        }
        if (!this.initialized && !this.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.name) + " There is a filter in carrier - can't execute command goToHomePosition.");
        }
        if (this.initialized && !this.isEmpty() && !this.loader.isAutochangerHoldingFilter()) {
            throw new BadCommandException(String.valueOf(this.name) + " There is a filter in carrier and Autochanger is not holding filter - can't execute command goToHomePosition. - can't execute command goToHomePosition.");
        }
        this.updatePosition();
        if (this.initialized && this.isAtHomePosition()) {
            throw new BadCommandException(String.valueOf(this.name) + " is already at home position.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION, this.timeoutForGoingToHomePosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close clamp.")
    public String close() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (!this.initialized) {
            throw new BadCommandException(String.valueOf(this.name) + " is not intialized. PLease initialize hardware first.");
        }
        this.loader.updateStateWithSensors();
        if (!this.loader.isConnectedOnCamera()) {
            throw new BadCommandException(String.valueOf(this.name) + " Loader not connected - can't execute close command.");
        }
        if (this.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.name) + " No filter in carrier - can't execute close command.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS, this.timeoutForClosingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clamp clamp.")
    public String clamp() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (!this.initialized) {
            throw new BadCommandException(String.valueOf(this.name) + " is not intialized. PLease initialize hardware first.");
        }
        if (this.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.name) + " No filter in carrier - can't execute close command.");
        }
        if (!this.isLocked()) {
            throw new BadCommandException(String.valueOf(this.name) + " has to be LOCKED first. Close hooks prior clamp.");
        }
        if (this.loader.isAutochangerHoldingFilter()) {
            throw new BadCommandException(String.valueOf(this.name) + " Autochanger is holding filter. Open autochanger latches before clamping loader hooks.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS, this.timeoutForClampingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open clamp.")
    public String open() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (!this.initialized) {
            throw new BadCommandException(String.valueOf(this.name) + " is not intialized. PLease initialize hardware first.");
        }
        if (!this.isEmpty() && !this.loader.isAutochangerHoldingFilter()) {
            throw new BadCommandException(String.valueOf(this.name) + " A filter is in the loader and Autochanger is not holding filter. Can't open loader hooks.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.OPENLOADERHOOKS, this.timeoutForOpeningHooks);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case GOTOCLAMPEDPOSITION: {
                fcslog.debug((Object)("readCurrent=" + this.readCurrent + " currentToClamp=" + this.currentToClamp), new String[0]);
                return this.currentToClamp - 5 <= this.readCurrent && this.readCurrent <= this.currentToClamp + 5;
            }
            case GOTOHOMEPOSITION: {
                fcslog.debug((Object)("readCurrent=" + this.readCurrent + " currentToGoHome=" + this.currentToGoHome), new String[0]);
                return this.currentToGoHome - 5 <= this.readCurrent && this.readCurrent <= this.currentToGoHome + 5;
            }
            case CLOSELOADERHOOKS: {
                return this.position == this.targetPositionToClose;
            }
            case CLAMPLOADERHOOKS: {
                return this.currentToClamp - 5 <= this.readCurrent && this.readCurrent <= this.currentToClamp + 5;
            }
            case OPENLOADERHOOKS: {
                return this.position == this.targetPositionToOpen;
            }
        }
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        this.updateStateWithSensors();
        if (this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS) || this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.OPENLOADERHOOKS)) {
            this.position = this.hooksController.readPosition();
        } else if (this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION) || this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.GOTOCLAMPEDPOSITION) || this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS)) {
            this.readCurrent = this.hooksController.readCurrent();
            this.position = this.hooksController.readPosition();
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        switch (action) {
            case GOTOCLAMPEDPOSITION: {
                this.hooksController.enable();
                this.hooksController.changeMode(CanOpenEPOS.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToClamp);
                this.hooksController.writeCurrent(this.currentToClamp);
                this.hooksController.on();
                break;
            }
            case GOTOHOMEPOSITION: {
                this.hooksController.enable();
                this.hooksController.changeMode(CanOpenEPOS.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToGoHome);
                this.hooksController.writeCurrent(this.currentToGoHome);
                this.hooksController.on();
                break;
            }
            case CLOSELOADERHOOKS: {
                this.hooksController.enable();
                this.hooksController.changeMode(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeParameters(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeTargetPosition(this.targetPositionToClose);
                this.hooksController.on();
                break;
            }
            case CLAMPLOADERHOOKS: {
                if (!this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                    throw new BadCommandException(String.valueOf(this.name) + ": Hooks have to be LOCKED before being LOCKED STRONGLY");
                }
                this.hooksController.enable();
                this.hooksController.changeMode(CanOpenEPOS.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToClamp);
                this.hooksController.writeCurrent(this.currentToClamp);
                this.hooksController.on();
                break;
            }
            case OPENLOADERHOOKS: {
                this.hooksController.enable();
                this.hooksController.changeMode(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeParameters(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeTargetPosition(this.targetPositionToOpen);
                this.hooksController.on();
            }
        }
    }

    @Override
    public void stopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        fcslog.debug((Object)(String.valueOf(this.name) + " is STOPPING action " + action.toString() + " within delay " + delay), new String[0]);
        CurrentCommandContext currentCmdContext = (CurrentCommandContext)Subsystem.LOCAL_EXECUTION_INFO.get();
        fcslog.debug((Object)("Command running:" + currentCmdContext.getCommandName()), new String[0]);
        fcslog.info((Object)("coming from:" + currentCmdContext.getCommandOriginator()), new String[0]);
        this.hooksController.off();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.hooksController.off();
        fcslog.info((Object)(String.valueOf(this.name) + ":" + action.toString() + " completed - doing postAction."), new String[0]);
        switch (action) {
            case GOTOCLAMPEDPOSITION: {
                if (!this.isLocked()) {
                    throw new ErrorInCommandExecutionException(String.valueOf(this.name) + ": check with sensors: clamp should be LOCKED.");
                }
                this.hooksController.defineAbsolutePosition(this.targetPositionToClamp);
                this.hooksController.off();
                this.updatePosition();
                this.publishData();
                break;
            }
            case GOTOHOMEPOSITION: {
                if (!this.isUnlocked()) {
                    throw new ErrorInCommandExecutionException(String.valueOf(this.name) + ": check with sensors: clamp should be UNLOCKED.");
                }
                this.hooksController.defineAbsolutePosition(0);
                this.hooksController.off();
                this.updatePosition();
                this.publishData();
                break;
            }
            case CLOSELOADERHOOKS: {
                if (this.isLocked()) break;
                throw new ErrorInCommandExecutionException(String.valueOf(this.name) + ": check with sensors: clamp should be LOCKED.");
            }
            case CLAMPLOADERHOOKS: {
                if (!this.isLocked() || !this.isAtClampedPosition()) break;
                this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
                this.publishData();
                break;
            }
            case OPENLOADERHOOKS: {
                if (this.isUnlocked()) break;
                throw new ErrorInCommandExecutionException(String.valueOf(this.name) + ": check with sensors: clamp should be UNLOCKED.");
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.loader.updateStateWithSensors();
    }

    protected void updateStateWithSensors(String[] readHexaValues) throws FcsHardwareException {
        this.lock.lock();
        try {
            boolean unlocked;
            this.updatingState = true;
            this.hook1.updateStateWithSensors(readHexaValues);
            this.hook2.updateStateWithSensors(readHexaValues);
            this.hook3.updateStateWithSensors(readHexaValues);
            this.hook4.updateStateWithSensors(readHexaValues);
            boolean inError = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook2.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook3.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook4.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
            boolean locked = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
            boolean bl = unlocked = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
            if (locked && unlocked) {
                inError = true;
            }
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (locked ? FcsEnumerations.LockStatus.LOCKED : (unlocked ? FcsEnumerations.LockStatus.UNLOCKED : FcsEnumerations.LockStatus.UNKNOWN));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp position in reading controller.")
    public void updatePosition() throws BadCommandException, SDORequestException {
        try {
            this.position = this.hooksController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            log.warning((Object)(String.valueOf(this.name) + "=> ERROR IN READING SENSOR:" + ex.getMessage()), new String[0]);
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String listHooks() {
        StringBuilder sb = new StringBuilder("Hooks status:");
        sb.append("\n");
        sb.append(this.hook1.toString());
        sb.append("/");
        sb.append(this.hook1.getLockStatus());
        sb.append("\n");
        sb.append(this.hook2.toString());
        sb.append("/");
        sb.append(this.hook2.getLockStatus());
        sb.append("\n");
        sb.append(this.hook3.toString());
        sb.append("/");
        sb.append(this.hook3.getLockStatus());
        sb.append("\n");
        sb.append(this.hook4.toString());
        sb.append("/");
        sb.append(this.hook4.getLockStatus());
        sb.append("\n");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp sensors values.")
    public String listSensorsValues() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.name) + "Sensors values=");
        sb.append("/");
        sb.append(this.hook1.listSensorsValues());
        sb.append("/");
        sb.append(this.hook2.listSensorsValues());
        sb.append("/");
        sb.append(this.hook3.listSensorsValues());
        sb.append("/");
        sb.append(this.hook4.listSensorsValues());
        sb.append("/");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp sensors values.")
    public String listStatus() {
        StringBuilder sb = new StringBuilder("Clamp status:");
        sb.append(this.lockStatus);
        sb.append("\n");
        sb.append(this.hook1.getName());
        sb.append("/");
        sb.append(this.hook1.getLockStatus());
        sb.append("\n");
        sb.append(this.hook2.getName());
        sb.append("/");
        sb.append(this.hook2.getLockStatus());
        sb.append("\n");
        sb.append(this.hook3.getName());
        sb.append("/");
        sb.append(this.hook3.getLockStatus());
        sb.append("\n");
        sb.append(this.hook4.getName());
        sb.append("/");
        sb.append(this.hook4.getLockStatus());
        sb.append("\n");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/timeoutForClosingHooks=");
        sb.append(this.timeoutForClosingHooks);
        sb.append("/timeoutForClosingHooksStrongly=");
        sb.append(this.timeoutForClampingHooks);
        sb.append("/timeoutForOpeningHooks=");
        sb.append(this.timeoutForOpeningHooks);
        return sb.toString();
    }

    public StatusDataPublishedByLoaderClamp getStatusData() {
        StatusDataPublishedByLoaderClamp status = FcsUtils.createStatusDataPublishedByLoaderClamp(this);
        return status;
    }

    public void publishData() {
        StatusDataPublishedByLoaderClamp status = this.getStatusData();
        this.publish("loaderClamp", status);
    }
}

