/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class LoaderCarrierModule
extends MobileItemModule {
    protected NumericSensor storagePositionSensor;
    protected NumericSensor handoffPositionSensor;
    private final String plutoGatewayName;
    private LoaderModule loader;
    final Condition stateUpdated;
    protected volatile boolean updatingState;
    private boolean atStorage;
    private boolean atHandoff;

    public LoaderCarrierModule(String moduleName, int aTickMillis, String plutoGatewayName) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.plutoGatewayName = plutoGatewayName;
        this.atHandoff = false;
        this.atStorage = false;
    }

    public void initModule() {
        this.loader = (LoaderModule)this.getModule("loader");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if loader hardware is connected and ready.")
    public boolean isHardwareReady() {
        return ((LoaderModule)this.getModule("loader")).isHardwareReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read the sensors and return true if a filter is in the loader.")
    public boolean checkFilterPresence() throws FcsHardwareException {
        this.updateStateWithSensors();
        return !this.isEmpty();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the loader. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        return this.loader.isEmpty();
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at storage position. This command doesn't read again the sensors.")
    public boolean isAtStoragePosition() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at storage position. This command doesn't read again the sensors.")
    public boolean isAtHandoffPosition() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected on the camera. This command doesn't read again the sensors.")
    public boolean isConnectedOnCamera() {
        return this.loader.isConnectedOnCamera();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the autochanger is holding the filter. This command doesn't read again the sensors.")
    public boolean isAutochangerHoldingFilter() {
        return this.loader.isAutochangerHoldingFilter();
    }

    public void goToHandOff() {
    }

    public void goToStorage() {
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        this.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.loader.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (!(action.equals((Object)FcsEnumerations.MobileItemAction.MOVELOADERCARRIERTOHANDOFF) || action.equals((Object)FcsEnumerations.MobileItemAction.MOVELOADERCARRIERTOSTORAGE) || action.equals((Object)FcsEnumerations.MobileItemAction.OPENLOADERHOOKS))) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + "Action on loader carrier must be MOVELOADERCARRIERTOHANDOFF or MOVELOADERCARRIERTOSTORAGE");
        }
    }

    @Override
    public void stopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
    }

    public void initialiazeHardware() {
    }
}

